@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentsCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateName Name of the Certificate.
 * @property connectedEnvironmentName Name of the Connected Environment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetConnectedEnvironmentsCertificatePlainArgs(
    public val certificateName: String,
    public val connectedEnvironmentName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentsCertificatePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentsCertificatePlainArgs =
        com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentsCertificatePlainArgs.builder()
            .certificateName(certificateName.let({ args0 -> args0 }))
            .connectedEnvironmentName(connectedEnvironmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectedEnvironmentsCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetConnectedEnvironmentsCertificatePlainArgsBuilder internal constructor() {
    private var certificateName: String? = null

    private var connectedEnvironmentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Certificate.
     */
    @JvmName("kdprjjbxgfmkykei")
    public suspend fun certificateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.certificateName = mapped
    }

    /**
     * @param value Name of the Connected Environment.
     */
    @JvmName("ylxetomdkhtyexwv")
    public suspend fun connectedEnvironmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectedEnvironmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ufachcfjsqxsmqxs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConnectedEnvironmentsCertificatePlainArgs =
        GetConnectedEnvironmentsCertificatePlainArgs(
            certificateName = certificateName ?: throw PulumiNullFieldException("certificateName"),
            connectedEnvironmentName = connectedEnvironmentName ?: throw
                PulumiNullFieldException("connectedEnvironmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
