@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentsDaprComponentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property componentName Name of the Dapr Component.
 * @property connectedEnvironmentName Name of the connected environment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetConnectedEnvironmentsDaprComponentPlainArgs(
    public val componentName: String,
    public val connectedEnvironmentName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentsDaprComponentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentsDaprComponentPlainArgs =
        com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentsDaprComponentPlainArgs.builder()
            .componentName(componentName.let({ args0 -> args0 }))
            .connectedEnvironmentName(connectedEnvironmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectedEnvironmentsDaprComponentPlainArgs].
 */
@PulumiTagMarker
public class GetConnectedEnvironmentsDaprComponentPlainArgsBuilder internal constructor() {
    private var componentName: String? = null

    private var connectedEnvironmentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Dapr Component.
     */
    @JvmName("txobedmrkvsfijcl")
    public suspend fun componentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.componentName = mapped
    }

    /**
     * @param value Name of the connected environment.
     */
    @JvmName("pxbbfedkeciuvvtb")
    public suspend fun connectedEnvironmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectedEnvironmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ocyqtfmjfvxndvjg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConnectedEnvironmentsDaprComponentPlainArgs =
        GetConnectedEnvironmentsDaprComponentPlainArgs(
            componentName = componentName ?: throw PulumiNullFieldException("componentName"),
            connectedEnvironmentName = connectedEnvironmentName ?: throw
                PulumiNullFieldException("connectedEnvironmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
