@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetDaprComponentResiliencyPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property componentName Name of the Dapr Component.
 * @property environmentName Name of the Managed Environment.
 * @property name Name of the Dapr Component Resiliency Policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDaprComponentResiliencyPolicyPlainArgs(
    public val componentName: String,
    public val environmentName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetDaprComponentResiliencyPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetDaprComponentResiliencyPolicyPlainArgs =
        com.pulumi.azurenative.app.inputs.GetDaprComponentResiliencyPolicyPlainArgs.builder()
            .componentName(componentName.let({ args0 -> args0 }))
            .environmentName(environmentName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDaprComponentResiliencyPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetDaprComponentResiliencyPolicyPlainArgsBuilder internal constructor() {
    private var componentName: String? = null

    private var environmentName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Dapr Component.
     */
    @JvmName("jkmumahkbsihxmjs")
    public suspend fun componentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.componentName = mapped
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("qcjfruqacuuexsax")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value Name of the Dapr Component Resiliency Policy.
     */
    @JvmName("vpudpdiflcsowclv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gpbhfxonfxncyebe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDaprComponentResiliencyPolicyPlainArgs =
        GetDaprComponentResiliencyPolicyPlainArgs(
            componentName = componentName ?: throw PulumiNullFieldException("componentName"),
            environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
