@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetJavaComponentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentName Name of the Managed Environment.
 * @property name Name of the Java Component.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetJavaComponentPlainArgs(
    public val environmentName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetJavaComponentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetJavaComponentPlainArgs =
        com.pulumi.azurenative.app.inputs.GetJavaComponentPlainArgs.builder()
            .environmentName(environmentName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJavaComponentPlainArgs].
 */
@PulumiTagMarker
public class GetJavaComponentPlainArgsBuilder internal constructor() {
    private var environmentName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("xwlwwkmpymkhdmty")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value Name of the Java Component.
     */
    @JvmName("jqlticgggilrdmma")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ugjqfsxighamrbed")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetJavaComponentPlainArgs = GetJavaComponentPlainArgs(
        environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
