@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetManagedEnvironmentsStoragePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentName Name of the Environment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageName Name of the storage.
 */
public data class GetManagedEnvironmentsStoragePlainArgs(
    public val environmentName: String,
    public val resourceGroupName: String,
    public val storageName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetManagedEnvironmentsStoragePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetManagedEnvironmentsStoragePlainArgs =
        com.pulumi.azurenative.app.inputs.GetManagedEnvironmentsStoragePlainArgs.builder()
            .environmentName(environmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageName(storageName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedEnvironmentsStoragePlainArgs].
 */
@PulumiTagMarker
public class GetManagedEnvironmentsStoragePlainArgsBuilder internal constructor() {
    private var environmentName: String? = null

    private var resourceGroupName: String? = null

    private var storageName: String? = null

    /**
     * @param value Name of the Environment.
     */
    @JvmName("xfgnwxeudtasgfdd")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("twnbvhwgwdplfyad")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the storage.
     */
    @JvmName("kfeofwfdkufsnrne")
    public suspend fun storageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageName = mapped
    }

    internal fun build(): GetManagedEnvironmentsStoragePlainArgs =
        GetManagedEnvironmentsStoragePlainArgs(
            environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            storageName = storageName ?: throw PulumiNullFieldException("storageName"),
        )
}
