@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ManagedCertificatePropertiesArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.ManagedCertificateDomainControlValidation
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Certificate resource specific properties
 * @property domainControlValidation Selected type of domain control validation for managed certificates.
 * @property subjectName Subject name of the certificate.
 */
public data class ManagedCertificatePropertiesArgs(
    public val domainControlValidation:
    Output<Either<String, ManagedCertificateDomainControlValidation>>? = null,
    public val subjectName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ManagedCertificatePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ManagedCertificatePropertiesArgs =
        com.pulumi.azurenative.app.inputs.ManagedCertificatePropertiesArgs.builder()
            .domainControlValidation(
                domainControlValidation?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .subjectName(subjectName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedCertificatePropertiesArgs].
 */
@PulumiTagMarker
public class ManagedCertificatePropertiesArgsBuilder internal constructor() {
    private var domainControlValidation:
        Output<Either<String, ManagedCertificateDomainControlValidation>>? = null

    private var subjectName: Output<String>? = null

    /**
     * @param value Selected type of domain control validation for managed certificates.
     */
    @JvmName("ntjogfhwhaytjsvp")
    public suspend
    fun domainControlValidation(`value`: Output<Either<String, ManagedCertificateDomainControlValidation>>) {
        this.domainControlValidation = value
    }

    /**
     * @param value Subject name of the certificate.
     */
    @JvmName("drtebxnlmxufjjmq")
    public suspend fun subjectName(`value`: Output<String>) {
        this.subjectName = value
    }

    /**
     * @param value Selected type of domain control validation for managed certificates.
     */
    @JvmName("lgyjamvacsmhjrnl")
    public suspend
    fun domainControlValidation(`value`: Either<String, ManagedCertificateDomainControlValidation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainControlValidation = mapped
    }

    /**
     * @param value Selected type of domain control validation for managed certificates.
     */
    @JvmName("xapbnycmpctaobin")
    public fun domainControlValidation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedCertificateDomainControlValidation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainControlValidation = mapped
    }

    /**
     * @param value Selected type of domain control validation for managed certificates.
     */
    @JvmName("rohaexgscpgvxybt")
    public fun domainControlValidation(`value`: ManagedCertificateDomainControlValidation) {
        val toBeMapped = Either.ofRight<String, ManagedCertificateDomainControlValidation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainControlValidation = mapped
    }

    /**
     * @param value Subject name of the certificate.
     */
    @JvmName("nntgwjucrbxxnujg")
    public suspend fun subjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectName = mapped
    }

    internal fun build(): ManagedCertificatePropertiesArgs = ManagedCertificatePropertiesArgs(
        domainControlValidation = domainControlValidation,
        subjectName = subjectName,
    )
}
