@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ScaleRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Container App container scaling rule.
 * @property azureQueue Azure Queue based scaling.
 * @property custom Custom scale rule.
 * @property http HTTP requests based scaling.
 * @property name Scale Rule Name
 * @property tcp Tcp requests based scaling.
 */
public data class ScaleRuleArgs(
    public val azureQueue: Output<QueueScaleRuleArgs>? = null,
    public val custom: Output<CustomScaleRuleArgs>? = null,
    public val http: Output<HttpScaleRuleArgs>? = null,
    public val name: Output<String>? = null,
    public val tcp: Output<TcpScaleRuleArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ScaleRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ScaleRuleArgs =
        com.pulumi.azurenative.app.inputs.ScaleRuleArgs.builder()
            .azureQueue(azureQueue?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .custom(custom?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .http(http?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tcp(tcp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ScaleRuleArgs].
 */
@PulumiTagMarker
public class ScaleRuleArgsBuilder internal constructor() {
    private var azureQueue: Output<QueueScaleRuleArgs>? = null

    private var custom: Output<CustomScaleRuleArgs>? = null

    private var http: Output<HttpScaleRuleArgs>? = null

    private var name: Output<String>? = null

    private var tcp: Output<TcpScaleRuleArgs>? = null

    /**
     * @param value Azure Queue based scaling.
     */
    @JvmName("ehpwopepamomrnrg")
    public suspend fun azureQueue(`value`: Output<QueueScaleRuleArgs>) {
        this.azureQueue = value
    }

    /**
     * @param value Custom scale rule.
     */
    @JvmName("fykunrkioniauwbj")
    public suspend fun custom(`value`: Output<CustomScaleRuleArgs>) {
        this.custom = value
    }

    /**
     * @param value HTTP requests based scaling.
     */
    @JvmName("ttirwmkajseivubn")
    public suspend fun http(`value`: Output<HttpScaleRuleArgs>) {
        this.http = value
    }

    /**
     * @param value Scale Rule Name
     */
    @JvmName("oaphlgkfajlprqbv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Tcp requests based scaling.
     */
    @JvmName("tctxctaubbqlxxxo")
    public suspend fun tcp(`value`: Output<TcpScaleRuleArgs>) {
        this.tcp = value
    }

    /**
     * @param value Azure Queue based scaling.
     */
    @JvmName("sxxpmglgkjhwjkgm")
    public suspend fun azureQueue(`value`: QueueScaleRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureQueue = mapped
    }

    /**
     * @param argument Azure Queue based scaling.
     */
    @JvmName("vpajsfkkbdoounew")
    public suspend fun azureQueue(argument: suspend QueueScaleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = QueueScaleRuleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureQueue = mapped
    }

    /**
     * @param value Custom scale rule.
     */
    @JvmName("iljducxbaepbbbpd")
    public suspend fun custom(`value`: CustomScaleRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.custom = mapped
    }

    /**
     * @param argument Custom scale rule.
     */
    @JvmName("wmwqhiapvlpyfvim")
    public suspend fun custom(argument: suspend CustomScaleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = CustomScaleRuleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.custom = mapped
    }

    /**
     * @param value HTTP requests based scaling.
     */
    @JvmName("yklqdpmsadvksjof")
    public suspend fun http(`value`: HttpScaleRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http = mapped
    }

    /**
     * @param argument HTTP requests based scaling.
     */
    @JvmName("ctmxxmscqhvuugix")
    public suspend fun http(argument: suspend HttpScaleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = HttpScaleRuleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.http = mapped
    }

    /**
     * @param value Scale Rule Name
     */
    @JvmName("enlkwmcqkvgdkjbh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tcp requests based scaling.
     */
    @JvmName("sypekkpvwgdsevym")
    public suspend fun tcp(`value`: TcpScaleRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcp = mapped
    }

    /**
     * @param argument Tcp requests based scaling.
     */
    @JvmName("nbkfglcwhnnbwlvx")
    public suspend fun tcp(argument: suspend TcpScaleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = TcpScaleRuleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tcp = mapped
    }

    internal fun build(): ScaleRuleArgs = ScaleRuleArgs(
        azureQueue = azureQueue,
        custom = custom,
        http = http,
        name = name,
        tcp = tcp,
    )
}
