@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.TcpRetryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Policy that defines tcp request retry conditions
 * @property maxConnectAttempts Maximum number of attempts to connect to the tcp service
 */
public data class TcpRetryPolicyArgs(
    public val maxConnectAttempts: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.TcpRetryPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.TcpRetryPolicyArgs =
        com.pulumi.azurenative.app.inputs.TcpRetryPolicyArgs.builder()
            .maxConnectAttempts(maxConnectAttempts?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TcpRetryPolicyArgs].
 */
@PulumiTagMarker
public class TcpRetryPolicyArgsBuilder internal constructor() {
    private var maxConnectAttempts: Output<Int>? = null

    /**
     * @param value Maximum number of attempts to connect to the tcp service
     */
    @JvmName("tlydtcwwlperxeoe")
    public suspend fun maxConnectAttempts(`value`: Output<Int>) {
        this.maxConnectAttempts = value
    }

    /**
     * @param value Maximum number of attempts to connect to the tcp service
     */
    @JvmName("qxghpjhkkrmdjpki")
    public suspend fun maxConnectAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConnectAttempts = mapped
    }

    internal fun build(): TcpRetryPolicyArgs = TcpRetryPolicyArgs(
        maxConnectAttempts = maxConnectAttempts,
    )
}
