@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.VnetConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration properties for apps environment to join a Virtual Network
 * @property dockerBridgeCidr CIDR notation IP range assigned to the Docker bridge, network. Must not overlap with any other provided IP ranges.
 * @property infrastructureSubnetId Resource ID of a subnet for infrastructure components. This subnet must be in the same VNET as the subnet defined in runtimeSubnetId. Must not overlap with any other provided IP ranges.
 * @property internal Boolean indicating the environment only has an internal load balancer. These environments do not have a public static IP resource. They must provide runtimeSubnetId and infrastructureSubnetId if enabling this property
 * @property outboundSettings Configuration used to control the Environment Egress outbound traffic
 * @property platformReservedCidr IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. Must not overlap with any other provided IP ranges.
 * @property platformReservedDnsIP  An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server.
 * @property runtimeSubnetId This field is deprecated and not used. If you wish to provide your own subnet that Container App containers are injected into, then you should leverage the infrastructureSubnetId.
 */
public data class VnetConfigurationArgs(
    public val dockerBridgeCidr: Output<String>? = null,
    public val infrastructureSubnetId: Output<String>? = null,
    public val `internal`: Output<Boolean>? = null,
    public val outboundSettings: Output<ManagedEnvironmentOutboundSettingsArgs>? = null,
    public val platformReservedCidr: Output<String>? = null,
    public val platformReservedDnsIP: Output<String>? = null,
    public val runtimeSubnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.VnetConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.VnetConfigurationArgs =
        com.pulumi.azurenative.app.inputs.VnetConfigurationArgs.builder()
            .dockerBridgeCidr(dockerBridgeCidr?.applyValue({ args0 -> args0 }))
            .infrastructureSubnetId(infrastructureSubnetId?.applyValue({ args0 -> args0 }))
            .`internal`(`internal`?.applyValue({ args0 -> args0 }))
            .outboundSettings(outboundSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .platformReservedCidr(platformReservedCidr?.applyValue({ args0 -> args0 }))
            .platformReservedDnsIP(platformReservedDnsIP?.applyValue({ args0 -> args0 }))
            .runtimeSubnetId(runtimeSubnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VnetConfigurationArgs].
 */
@PulumiTagMarker
public class VnetConfigurationArgsBuilder internal constructor() {
    private var dockerBridgeCidr: Output<String>? = null

    private var infrastructureSubnetId: Output<String>? = null

    private var `internal`: Output<Boolean>? = null

    private var outboundSettings: Output<ManagedEnvironmentOutboundSettingsArgs>? = null

    private var platformReservedCidr: Output<String>? = null

    private var platformReservedDnsIP: Output<String>? = null

    private var runtimeSubnetId: Output<String>? = null

    /**
     * @param value CIDR notation IP range assigned to the Docker bridge, network. Must not overlap with any other provided IP ranges.
     */
    @JvmName("gberxdriogbxfqjg")
    public suspend fun dockerBridgeCidr(`value`: Output<String>) {
        this.dockerBridgeCidr = value
    }

    /**
     * @param value Resource ID of a subnet for infrastructure components. This subnet must be in the same VNET as the subnet defined in runtimeSubnetId. Must not overlap with any other provided IP ranges.
     */
    @JvmName("gibweonwqfqvycqk")
    public suspend fun infrastructureSubnetId(`value`: Output<String>) {
        this.infrastructureSubnetId = value
    }

    /**
     * @param value Boolean indicating the environment only has an internal load balancer. These environments do not have a public static IP resource. They must provide runtimeSubnetId and infrastructureSubnetId if enabling this property
     */
    @JvmName("syksdmjtamrhqfme")
    public suspend fun `internal`(`value`: Output<Boolean>) {
        this.`internal` = value
    }

    /**
     * @param value Configuration used to control the Environment Egress outbound traffic
     */
    @JvmName("hvflycsnjybskfnr")
    public suspend fun outboundSettings(`value`: Output<ManagedEnvironmentOutboundSettingsArgs>) {
        this.outboundSettings = value
    }

    /**
     * @param value IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. Must not overlap with any other provided IP ranges.
     */
    @JvmName("sbfmrxtnbfmiahdl")
    public suspend fun platformReservedCidr(`value`: Output<String>) {
        this.platformReservedCidr = value
    }

    /**
     * @param value  An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server.
     */
    @JvmName("hoffgstkkprxteli")
    public suspend fun platformReservedDnsIP(`value`: Output<String>) {
        this.platformReservedDnsIP = value
    }

    /**
     * @param value This field is deprecated and not used. If you wish to provide your own subnet that Container App containers are injected into, then you should leverage the infrastructureSubnetId.
     */
    @JvmName("dncclvxsbxxpnyqd")
    public suspend fun runtimeSubnetId(`value`: Output<String>) {
        this.runtimeSubnetId = value
    }

    /**
     * @param value CIDR notation IP range assigned to the Docker bridge, network. Must not overlap with any other provided IP ranges.
     */
    @JvmName("kbupojloacfyjste")
    public suspend fun dockerBridgeCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dockerBridgeCidr = mapped
    }

    /**
     * @param value Resource ID of a subnet for infrastructure components. This subnet must be in the same VNET as the subnet defined in runtimeSubnetId. Must not overlap with any other provided IP ranges.
     */
    @JvmName("qcpltjblqucgqncm")
    public suspend fun infrastructureSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureSubnetId = mapped
    }

    /**
     * @param value Boolean indicating the environment only has an internal load balancer. These environments do not have a public static IP resource. They must provide runtimeSubnetId and infrastructureSubnetId if enabling this property
     */
    @JvmName("qqurcvvtxmevfydx")
    public suspend fun `internal`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`internal` = mapped
    }

    /**
     * @param value Configuration used to control the Environment Egress outbound traffic
     */
    @JvmName("ecuapcwelbaxcuav")
    public suspend fun outboundSettings(`value`: ManagedEnvironmentOutboundSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundSettings = mapped
    }

    /**
     * @param argument Configuration used to control the Environment Egress outbound traffic
     */
    @JvmName("anpvrvkndaqqensj")
    public suspend
    fun outboundSettings(argument: suspend ManagedEnvironmentOutboundSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedEnvironmentOutboundSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.outboundSettings = mapped
    }

    /**
     * @param value IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. Must not overlap with any other provided IP ranges.
     */
    @JvmName("qmdasucdxcfbnjmd")
    public suspend fun platformReservedCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformReservedCidr = mapped
    }

    /**
     * @param value  An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server.
     */
    @JvmName("esywrfubtdouncfv")
    public suspend fun platformReservedDnsIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformReservedDnsIP = mapped
    }

    /**
     * @param value This field is deprecated and not used. If you wish to provide your own subnet that Container App containers are injected into, then you should leverage the infrastructureSubnetId.
     */
    @JvmName("qvuwcuqyvdeioymf")
    public suspend fun runtimeSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeSubnetId = mapped
    }

    internal fun build(): VnetConfigurationArgs = VnetConfigurationArgs(
        dockerBridgeCidr = dockerBridgeCidr,
        infrastructureSubnetId = infrastructureSubnetId,
        `internal` = `internal`,
        outboundSettings = outboundSettings,
        platformReservedCidr = platformReservedCidr,
        platformReservedDnsIP = platformReservedDnsIP,
        runtimeSubnetId = runtimeSubnetId,
    )
}
