@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.WorkloadProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Workload profile to scope container app execution.
 * @property maximumCount The maximum capacity.
 * @property minimumCount The minimum capacity.
 * @property workloadProfileType Workload profile type for the workloads to run on.
 */
public data class WorkloadProfileArgs(
    public val maximumCount: Output<Int>,
    public val minimumCount: Output<Int>,
    public val workloadProfileType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.WorkloadProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.WorkloadProfileArgs =
        com.pulumi.azurenative.app.inputs.WorkloadProfileArgs.builder()
            .maximumCount(maximumCount.applyValue({ args0 -> args0 }))
            .minimumCount(minimumCount.applyValue({ args0 -> args0 }))
            .workloadProfileType(workloadProfileType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadProfileArgs].
 */
@PulumiTagMarker
public class WorkloadProfileArgsBuilder internal constructor() {
    private var maximumCount: Output<Int>? = null

    private var minimumCount: Output<Int>? = null

    private var workloadProfileType: Output<String>? = null

    /**
     * @param value The maximum capacity.
     */
    @JvmName("moalygnqhjdmprud")
    public suspend fun maximumCount(`value`: Output<Int>) {
        this.maximumCount = value
    }

    /**
     * @param value The minimum capacity.
     */
    @JvmName("lmuerfhjkswpnkho")
    public suspend fun minimumCount(`value`: Output<Int>) {
        this.minimumCount = value
    }

    /**
     * @param value Workload profile type for the workloads to run on.
     */
    @JvmName("ajjlryetmigdtkoo")
    public suspend fun workloadProfileType(`value`: Output<String>) {
        this.workloadProfileType = value
    }

    /**
     * @param value The maximum capacity.
     */
    @JvmName("khuugxgedhskatux")
    public suspend fun maximumCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximumCount = mapped
    }

    /**
     * @param value The minimum capacity.
     */
    @JvmName("jjddayahrmmyforc")
    public suspend fun minimumCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumCount = mapped
    }

    /**
     * @param value Workload profile type for the workloads to run on.
     */
    @JvmName("dpffyqffvikejyby")
    public suspend fun workloadProfileType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadProfileType = mapped
    }

    internal fun build(): WorkloadProfileArgs = WorkloadProfileArgs(
        maximumCount = maximumCount ?: throw PulumiNullFieldException("maximumCount"),
        minimumCount = minimumCount ?: throw PulumiNullFieldException("minimumCount"),
        workloadProfileType = workloadProfileType ?: throw PulumiNullFieldException("workloadProfileType"),
    )
}
