@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Cross-Origin-Resource-Sharing policy
 * @property allowCredentials allow credential or not
 * @property allowedHeaders allowed HTTP headers
 * @property allowedMethods allowed HTTP methods
 * @property allowedOrigins allowed origins
 * @property exposeHeaders expose HTTP headers
 * @property maxAge max time client can cache the result
 */
public data class CorsPolicyResponse(
    public val allowCredentials: Boolean? = null,
    public val allowedHeaders: List<String>? = null,
    public val allowedMethods: List<String>? = null,
    public val allowedOrigins: List<String>,
    public val exposeHeaders: List<String>? = null,
    public val maxAge: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.CorsPolicyResponse):
            CorsPolicyResponse = CorsPolicyResponse(
            allowCredentials = javaType.allowCredentials().map({ args0 -> args0 }).orElse(null),
            allowedHeaders = javaType.allowedHeaders().map({ args0 -> args0 }),
            allowedMethods = javaType.allowedMethods().map({ args0 -> args0 }),
            allowedOrigins = javaType.allowedOrigins().map({ args0 -> args0 }),
            exposeHeaders = javaType.exposeHeaders().map({ args0 -> args0 }),
            maxAge = javaType.maxAge().map({ args0 -> args0 }).orElse(null),
        )
    }
}
