@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The configuration settings of the Azure Active Directory default authorization policy.
 * @property allowedApplications The configuration settings of the Azure Active Directory allowed applications.
 * @property allowedPrincipals The configuration settings of the Azure Active Directory allowed principals.
 */
public data class DefaultAuthorizationPolicyResponse(
    public val allowedApplications: List<String>? = null,
    public val allowedPrincipals: AllowedPrincipalsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.DefaultAuthorizationPolicyResponse):
            DefaultAuthorizationPolicyResponse = DefaultAuthorizationPolicyResponse(
            allowedApplications = javaType.allowedApplications().map({ args0 -> args0 }),
            allowedPrincipals = javaType.allowedPrincipals().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.AllowedPrincipalsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
