@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information pertaining to an individual build.
 * @property buildStatus Status of the build once it has been provisioned.
 * @property configuration Configuration of the build.
 * @property destinationContainerRegistry Container registry that the final image will be uploaded to.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property logStreamEndpoint Endpoint from which the build logs can be streamed.
 * @property name The name of the resource
 * @property provisioningState Build provisioning state.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tokenEndpoint Endpoint to use to retrieve an authentication token for log streaming and uploading source code.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property uploadEndpoint Endpoint to which the source code should be uploaded.
 */
public data class GetBuildResult(
    public val buildStatus: String,
    public val configuration: BuildConfigurationResponse? = null,
    public val destinationContainerRegistry: ContainerRegistryWithCustomImageResponse? = null,
    public val id: String,
    public val logStreamEndpoint: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tokenEndpoint: String,
    public val type: String,
    public val uploadEndpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GetBuildResult): GetBuildResult =
            GetBuildResult(
                buildStatus = javaType.buildStatus(),
                configuration = javaType.configuration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.BuildConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                destinationContainerRegistry = javaType.destinationContainerRegistry().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.ContainerRegistryWithCustomImageResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                id = javaType.id(),
                logStreamEndpoint = javaType.logStreamEndpoint(),
                name = javaType.name(),
                provisioningState = javaType.provisioningState(),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                tokenEndpoint = javaType.tokenEndpoint(),
                type = javaType.type(),
                uploadEndpoint = javaType.uploadEndpoint(),
            )
    }
}
