@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Java Component.
 * @property componentType Type of the Java Component.
 * @property configurations List of Java Components configuration properties
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the Java Component.
 * @property serviceBinds List of Java Components that are bound to the Java component
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetJavaComponentResult(
    public val componentType: String? = null,
    public val configurations: List<JavaComponentConfigurationPropertyResponse>? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val serviceBinds: List<JavaComponentServiceBindResponse>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GetJavaComponentResult):
            GetJavaComponentResult = GetJavaComponentResult(
            componentType = javaType.componentType().map({ args0 -> args0 }).orElse(null),
            configurations = javaType.configurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.JavaComponentConfigurationPropertyResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            serviceBinds = javaType.serviceBinds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.JavaComponentServiceBindResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
