@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The configuration settings of the checks that should be made while validating the JWT Claims.
 * @property allowedClientApplications The list of the allowed client applications.
 * @property allowedGroups The list of the allowed groups.
 */
public data class JwtClaimChecksResponse(
    public val allowedClientApplications: List<String>? = null,
    public val allowedGroups: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.JwtClaimChecksResponse):
            JwtClaimChecksResponse = JwtClaimChecksResponse(
            allowedClientApplications = javaType.allowedClientApplications().map({ args0 -> args0 }),
            allowedGroups = javaType.allowedGroups().map({ args0 -> args0 }),
        )
    }
}
