@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the app registration for the custom Open ID Connect provider.
 * @property clientCredential The authentication credentials of the custom Open ID Connect provider.
 * @property clientId The client id of the custom Open ID Connect provider.
 * @property openIdConnectConfiguration The configuration settings of the endpoints used for the custom Open ID Connect provider.
 */
public data class OpenIdConnectRegistrationResponse(
    public val clientCredential: OpenIdConnectClientCredentialResponse? = null,
    public val clientId: String? = null,
    public val openIdConnectConfiguration: OpenIdConnectConfigResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.OpenIdConnectRegistrationResponse):
            OpenIdConnectRegistrationResponse = OpenIdConnectRegistrationResponse(
            clientCredential = javaType.clientCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.OpenIdConnectClientCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            openIdConnectConfiguration = javaType.openIdConnectConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.OpenIdConnectConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
