@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Configuration properties for apps environment to join a Virtual Network
 * @property dockerBridgeCidr CIDR notation IP range assigned to the Docker bridge, network. Must not overlap with any other provided IP ranges.
 * @property infrastructureSubnetId Resource ID of a subnet for infrastructure components. This subnet must be in the same VNET as the subnet defined in runtimeSubnetId. Must not overlap with any other provided IP ranges.
 * @property internal Boolean indicating the environment only has an internal load balancer. These environments do not have a public static IP resource. They must provide runtimeSubnetId and infrastructureSubnetId if enabling this property
 * @property outboundSettings Configuration used to control the Environment Egress outbound traffic
 * @property platformReservedCidr IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. Must not overlap with any other provided IP ranges.
 * @property platformReservedDnsIP  An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server.
 * @property runtimeSubnetId This field is deprecated and not used. If you wish to provide your own subnet that Container App containers are injected into, then you should leverage the infrastructureSubnetId.
 */
public data class VnetConfigurationResponse(
    public val dockerBridgeCidr: String? = null,
    public val infrastructureSubnetId: String? = null,
    public val `internal`: Boolean? = null,
    public val outboundSettings: ManagedEnvironmentOutboundSettingsResponse? = null,
    public val platformReservedCidr: String? = null,
    public val platformReservedDnsIP: String? = null,
    public val runtimeSubnetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.VnetConfigurationResponse):
            VnetConfigurationResponse = VnetConfigurationResponse(
            dockerBridgeCidr = javaType.dockerBridgeCidr().map({ args0 -> args0 }).orElse(null),
            infrastructureSubnetId = javaType.infrastructureSubnetId().map({ args0 -> args0 }).orElse(null),
            `internal` = javaType.`internal`().map({ args0 -> args0 }).orElse(null),
            outboundSettings = javaType.outboundSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ManagedEnvironmentOutboundSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            platformReservedCidr = javaType.platformReservedCidr().map({ args0 -> args0 }).orElse(null),
            platformReservedDnsIP = javaType.platformReservedDnsIP().map({ args0 -> args0 }).orElse(null),
            runtimeSubnetId = javaType.runtimeSubnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
