@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Volume definitions for the Container App.
 * @property mountOptions Mount options used while mounting the AzureFile. Must be a comma-separated string.
 * @property name Volume name.
 * @property secrets List of secrets to be added in volume. If no secrets are provided, all secrets in collection will be added to volume.
 * @property storageName Name of storage resource. No need to provide for EmptyDir and Secret.
 * @property storageType Storage type for the volume. If not provided, use EmptyDir.
 */
public data class VolumeResponse(
    public val mountOptions: String? = null,
    public val name: String? = null,
    public val secrets: List<SecretVolumeItemResponse>? = null,
    public val storageName: String? = null,
    public val storageType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.VolumeResponse): VolumeResponse =
            VolumeResponse(
                mountOptions = javaType.mountOptions().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                secrets = javaType.secrets().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.SecretVolumeItemResponse.Companion.toKotlin(args0)
                    })
                }),
                storageName = javaType.storageName().map({ args0 -> args0 }).orElse(null),
                storageType = javaType.storageType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
