@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Workload profile to scope container app execution.
 * @property maximumCount The maximum capacity.
 * @property minimumCount The minimum capacity.
 * @property workloadProfileType Workload profile type for the workloads to run on.
 */
public data class WorkloadProfileResponse(
    public val maximumCount: Int,
    public val minimumCount: Int,
    public val workloadProfileType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.WorkloadProfileResponse):
            WorkloadProfileResponse = WorkloadProfileResponse(
            maximumCount = javaType.maximumCount(),
            minimumCount = javaType.minimumCount(),
            workloadProfileType = javaType.workloadProfileType(),
        )
    }
}
