@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin

import com.pulumi.azurenative.appconfiguration.kotlin.outputs.EncryptionPropertiesResponse
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.PrivateEndpointConnectionReferenceResponse
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.ResourceIdentityResponse
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.EncryptionPropertiesResponse.Companion.toKotlin as encryptionPropertiesResponseToKotlin
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.PrivateEndpointConnectionReferenceResponse.Companion.toKotlin as privateEndpointConnectionReferenceResponseToKotlin
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin as resourceIdentityResponseToKotlin
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.appconfiguration.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConfigurationStore].
 */
@PulumiTagMarker
public class ConfigurationStoreResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationStoreArgs = ConfigurationStoreArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationStoreArgsBuilder.() -> Unit) {
        val builder = ConfigurationStoreArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConfigurationStore {
        val builtJavaResource =
            com.pulumi.azurenative.appconfiguration.ConfigurationStore(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationStore(builtJavaResource)
    }
}

/**
 * The configuration store along with all resource properties. The Configuration Store will have all information to begin utilizing it.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2019-02-01-preview, 2023-08-01-preview, 2023-09-01-preview.
 * ## Example Usage
 * ### ConfigurationStores_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationStore = new AzureNative.AppConfiguration.ConfigurationStore("configurationStore", new()
 *     {
 *         ConfigStoreName = "contoso",
 *         Location = "westus",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.AppConfiguration.Inputs.SkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "myTag", "myTagValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appconfiguration.NewConfigurationStore(ctx, "configurationStore", &appconfiguration.ConfigurationStoreArgs{
 * 			ConfigStoreName:   pulumi.String("contoso"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &appconfiguration.SkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"myTag": pulumi.String("myTagValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appconfiguration.ConfigurationStore;
 * import com.pulumi.azurenative.appconfiguration.ConfigurationStoreArgs;
 * import com.pulumi.azurenative.appconfiguration.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationStore = new ConfigurationStore("configurationStore", ConfigurationStoreArgs.builder()
 *             .configStoreName("contoso")
 *             .location("westus")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .tags(Map.of("myTag", "myTagValue"))
 *             .build());
 *     }
 * }
 * ```
 * ### ConfigurationStores_Create_With_Local_Auth_Disabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationStore = new AzureNative.AppConfiguration.ConfigurationStore("configurationStore", new()
 *     {
 *         ConfigStoreName = "contoso",
 *         DisableLocalAuth = true,
 *         Location = "westus",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.AppConfiguration.Inputs.SkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appconfiguration.NewConfigurationStore(ctx, "configurationStore", &appconfiguration.ConfigurationStoreArgs{
 * 			ConfigStoreName:   pulumi.String("contoso"),
 * 			DisableLocalAuth:  pulumi.Bool(true),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &appconfiguration.SkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appconfiguration.ConfigurationStore;
 * import com.pulumi.azurenative.appconfiguration.ConfigurationStoreArgs;
 * import com.pulumi.azurenative.appconfiguration.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationStore = new ConfigurationStore("configurationStore", ConfigurationStoreArgs.builder()
 *             .configStoreName("contoso")
 *             .disableLocalAuth(true)
 *             .location("westus")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appconfiguration:ConfigurationStore contoso /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}
 * ```
 */
public class ConfigurationStore internal constructor(
    override val javaResource: com.pulumi.azurenative.appconfiguration.ConfigurationStore,
) : KotlinCustomResource(javaResource, ConfigurationStoreMapper) {
    /**
     * The creation date of configuration store.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * Disables all authentication methods other than AAD authentication.
     */
    public val disableLocalAuth: Output<Boolean>?
        get() = javaResource.disableLocalAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Property specifying whether protection against purge is enabled for this configuration store.
     */
    public val enablePurgeProtection: Output<Boolean>?
        get() = javaResource.enablePurgeProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The encryption settings of the configuration store.
     */
    public val encryption: Output<EncryptionPropertiesResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    encryptionPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The DNS endpoint where the configuration store API will be available.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * The managed identity information, if configured.
     */
    public val identity: Output<ResourceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of private endpoint connections that are set up for this resource.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionReferenceResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionReferenceResponseToKotlin(args0) })
            })
        })

    /**
     * The provisioning state of the configuration store.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Control permission for data plane traffic coming from public networks while private endpoint is enabled.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The sku of the configuration store.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * The amount of time in days that the configuration store will be retained when it is soft deleted.
     */
    public val softDeleteRetentionInDays: Output<Int>?
        get() = javaResource.softDeleteRetentionInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource system metadata.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationStoreMapper : ResourceMapper<ConfigurationStore> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appconfiguration.ConfigurationStore::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationStore = ConfigurationStore(
        javaResource as
            com.pulumi.azurenative.appconfiguration.ConfigurationStore,
    )
}

/**
 * @see [ConfigurationStore].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationStore].
 */
public suspend fun configurationStore(
    name: String,
    block: suspend ConfigurationStoreResourceBuilder.() -> Unit,
): ConfigurationStore {
    val builder = ConfigurationStoreResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationStore].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationStore(name: String): ConfigurationStore {
    val builder = ConfigurationStoreResourceBuilder()
    builder.name(name)
    return builder.build()
}
