@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.inputs

import com.pulumi.azurenative.appconfiguration.inputs.GetReplicaPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configStoreName The name of the configuration store.
 * @property replicaName The name of the replica.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 */
public data class GetReplicaPlainArgs(
    public val configStoreName: String,
    public val replicaName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appconfiguration.inputs.GetReplicaPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appconfiguration.inputs.GetReplicaPlainArgs =
        com.pulumi.azurenative.appconfiguration.inputs.GetReplicaPlainArgs.builder()
            .configStoreName(configStoreName.let({ args0 -> args0 }))
            .replicaName(replicaName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicaPlainArgs].
 */
@PulumiTagMarker
public class GetReplicaPlainArgsBuilder internal constructor() {
    private var configStoreName: String? = null

    private var replicaName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the configuration store.
     */
    @JvmName("bbmlbowyvgttjops")
    public suspend fun configStoreName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configStoreName = mapped
    }

    /**
     * @param value The name of the replica.
     */
    @JvmName("ntprmklfqinoakkp")
    public suspend fun replicaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.replicaName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("wpojsmbbmaijreib")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetReplicaPlainArgs = GetReplicaPlainArgs(
        configStoreName = configStoreName ?: throw PulumiNullFieldException("configStoreName"),
        replicaName = replicaName ?: throw PulumiNullFieldException("replicaName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
