@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.ApiPortalArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.ApiPortalPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.ApiPortalPropertiesArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * API portal resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### ApiPortals_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiPortal = new AzureNative.AppPlatform.ApiPortal("apiPortal", new()
 *     {
 *         ApiPortalName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.ApiPortalPropertiesArgs
 *         {
 *             GatewayIds = new[]
 *             {
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/gateways/default",
 *             },
 *             Public = true,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "E0",
 *             Tier = "Enterprise",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewApiPortal(ctx, "apiPortal", &appplatform.ApiPortalArgs{
 * 			ApiPortalName: pulumi.String("default"),
 * 			Properties: &appplatform.ApiPortalPropertiesArgs{
 * 				GatewayIds: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/gateways/default"),
 * 				},
 * 				Public: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("E0"),
 * 				Tier:     pulumi.String("Enterprise"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ApiPortal;
 * import com.pulumi.azurenative.appplatform.ApiPortalArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ApiPortalPropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiPortal = new ApiPortal("apiPortal", ApiPortalArgs.builder()
 *             .apiPortalName("default")
 *             .properties(ApiPortalPropertiesArgs.builder()
 *                 .gatewayIds("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/gateways/default")
 *                 .public_(true)
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(SkuArgs.builder()
 *                 .capacity(2)
 *                 .name("E0")
 *                 .tier("Enterprise")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:ApiPortal default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apiPortals/{apiPortalName}
 * ```
 * @property apiPortalName The name of API portal.
 * @property properties API portal properties payload
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 * @property sku Sku of the API portal resource
 */
public data class ApiPortalArgs(
    public val apiPortalName: Output<String>? = null,
    public val properties: Output<ApiPortalPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.ApiPortalArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.ApiPortalArgs =
        com.pulumi.azurenative.appplatform.ApiPortalArgs.builder()
            .apiPortalName(apiPortalName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApiPortalArgs].
 */
@PulumiTagMarker
public class ApiPortalArgsBuilder internal constructor() {
    private var apiPortalName: Output<String>? = null

    private var properties: Output<ApiPortalPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    /**
     * @param value The name of API portal.
     */
    @JvmName("dxpdvjesqpakggys")
    public suspend fun apiPortalName(`value`: Output<String>) {
        this.apiPortalName = value
    }

    /**
     * @param value API portal properties payload
     */
    @JvmName("hvptxdmsmxyuoxhf")
    public suspend fun properties(`value`: Output<ApiPortalPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("wdwowxroanuyaktq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("nqxjqhlxlyfegjyg")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Sku of the API portal resource
     */
    @JvmName("rdhkgdykvsumxnor")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The name of API portal.
     */
    @JvmName("gmpnycoscgjvwmdn")
    public suspend fun apiPortalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiPortalName = mapped
    }

    /**
     * @param value API portal properties payload
     */
    @JvmName("ndnonnwcmreyujpw")
    public suspend fun properties(`value`: ApiPortalPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument API portal properties payload
     */
    @JvmName("jkrgdjrflrptnjtb")
    public suspend fun properties(argument: suspend ApiPortalPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ApiPortalPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("uletijupsbhpnrgj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("tcjwfgyowdapskdj")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Sku of the API portal resource
     */
    @JvmName("uqmgnubjaljyyjxa")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku of the API portal resource
     */
    @JvmName("awfsqjrpsxfebuqx")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    internal fun build(): ApiPortalArgs = ApiPortalArgs(
        apiPortalName = apiPortalName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        sku = sku,
    )
}
