@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.ApplicationAcceleratorPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.ApplicationAcceleratorPropertiesResponse.Companion.toKotlin as applicationAcceleratorPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ApplicationAccelerator].
 */
@PulumiTagMarker
public class ApplicationAcceleratorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationAcceleratorArgs = ApplicationAcceleratorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationAcceleratorArgsBuilder.() -> Unit) {
        val builder = ApplicationAcceleratorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationAccelerator {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.ApplicationAccelerator(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApplicationAccelerator(builtJavaResource)
    }
}

/**
 * Application accelerator resource
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### ApplicationAccelerators_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var applicationAccelerator = new AzureNative.AppPlatform.ApplicationAccelerator("applicationAccelerator", new()
 *     {
 *         ApplicationAcceleratorName = "default",
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "E0",
 *             Tier = "Enterprise",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewApplicationAccelerator(ctx, "applicationAccelerator", &appplatform.ApplicationAcceleratorArgs{
 * 			ApplicationAcceleratorName: pulumi.String("default"),
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			ServiceName:                pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("E0"),
 * 				Tier:     pulumi.String("Enterprise"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ApplicationAccelerator;
 * import com.pulumi.azurenative.appplatform.ApplicationAcceleratorArgs;
 * import com.pulumi.azurenative.appplatform.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var applicationAccelerator = new ApplicationAccelerator("applicationAccelerator", ApplicationAcceleratorArgs.builder()
 *             .applicationAcceleratorName("default")
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(SkuArgs.builder()
 *                 .capacity(2)
 *                 .name("E0")
 *                 .tier("Enterprise")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:ApplicationAccelerator default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationAccelerators/{applicationAcceleratorName}
 * ```
 */
public class ApplicationAccelerator internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.ApplicationAccelerator,
) : KotlinCustomResource(javaResource, ApplicationAcceleratorMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Application accelerator properties payload
     */
    public val properties: Output<ApplicationAcceleratorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationAcceleratorPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Sku of the application accelerator resource
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApplicationAcceleratorMapper : ResourceMapper<ApplicationAccelerator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.ApplicationAccelerator::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationAccelerator =
        ApplicationAccelerator(
            javaResource as
                com.pulumi.azurenative.appplatform.ApplicationAccelerator,
        )
}

/**
 * @see [ApplicationAccelerator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationAccelerator].
 */
public suspend fun applicationAccelerator(
    name: String,
    block: suspend ApplicationAcceleratorResourceBuilder.() -> Unit,
): ApplicationAccelerator {
    val builder = ApplicationAcceleratorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationAccelerator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationAccelerator(name: String): ApplicationAccelerator {
    val builder = ApplicationAcceleratorResourceBuilder()
    builder.name(name)
    return builder.build()
}
