@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.ApplicationLiveViewPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.ApplicationLiveViewPropertiesResponse.Companion.toKotlin as applicationLiveViewPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ApplicationLiveView].
 */
@PulumiTagMarker
public class ApplicationLiveViewResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationLiveViewArgs = ApplicationLiveViewArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationLiveViewArgsBuilder.() -> Unit) {
        val builder = ApplicationLiveViewArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationLiveView {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.ApplicationLiveView(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApplicationLiveView(builtJavaResource)
    }
}

/**
 * Application Live View resource
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### ApplicationLiveViews_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var applicationLiveView = new AzureNative.AppPlatform.ApplicationLiveView("applicationLiveView", new()
 *     {
 *         ApplicationLiveViewName = "default",
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewApplicationLiveView(ctx, "applicationLiveView", &appplatform.ApplicationLiveViewArgs{
 * 			ApplicationLiveViewName: pulumi.String("default"),
 * 			ResourceGroupName:       pulumi.String("myResourceGroup"),
 * 			ServiceName:             pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ApplicationLiveView;
 * import com.pulumi.azurenative.appplatform.ApplicationLiveViewArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var applicationLiveView = new ApplicationLiveView("applicationLiveView", ApplicationLiveViewArgs.builder()
 *             .applicationLiveViewName("default")
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:ApplicationLiveView default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/applicationLiveViews/{applicationLiveViewName}
 * ```
 */
public class ApplicationLiveView internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.ApplicationLiveView,
) : KotlinCustomResource(javaResource, ApplicationLiveViewMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Application Live View properties payload
     */
    public val properties: Output<ApplicationLiveViewPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationLiveViewPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApplicationLiveViewMapper : ResourceMapper<ApplicationLiveView> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.ApplicationLiveView::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationLiveView = ApplicationLiveView(
        javaResource
            as com.pulumi.azurenative.appplatform.ApplicationLiveView,
    )
}

/**
 * @see [ApplicationLiveView].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationLiveView].
 */
public suspend fun applicationLiveView(
    name: String,
    block: suspend ApplicationLiveViewResourceBuilder.() -> Unit,
): ApplicationLiveView {
    val builder = ApplicationLiveViewResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationLiveView].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationLiveView(name: String): ApplicationLiveView {
    val builder = ApplicationLiveViewResourceBuilder()
    builder.name(name)
    return builder.build()
}
