@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.BindingArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.BindingResourcePropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.BindingResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Binding resource payload
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### Bindings_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var binding = new AzureNative.AppPlatform.Binding("binding", new()
 *     {
 *         AppName = "myapp",
 *         BindingName = "mybinding",
 *         Properties = new AzureNative.AppPlatform.Inputs.BindingResourcePropertiesArgs
 *         {
 *             BindingParameters =
 *             {
 *                 { "apiType", "SQL" },
 *                 { "databaseName", "db1" },
 *             },
 *             Key = "xxxx",
 *             ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.DocumentDB/databaseAccounts/my-cosmosdb-1",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewBinding(ctx, "binding", &appplatform.BindingArgs{
 * 			AppName:     pulumi.String("myapp"),
 * 			BindingName: pulumi.String("mybinding"),
 * 			Properties: &appplatform.BindingResourcePropertiesArgs{
 * 				BindingParameters: pulumi.StringMap{
 * 					"apiType":      pulumi.String("SQL"),
 * 					"databaseName": pulumi.String("db1"),
 * 				},
 * 				Key:        pulumi.String("xxxx"),
 * 				ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.DocumentDB/databaseAccounts/my-cosmosdb-1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Binding;
 * import com.pulumi.azurenative.appplatform.BindingArgs;
 * import com.pulumi.azurenative.appplatform.inputs.BindingResourcePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var binding = new Binding("binding", BindingArgs.builder()
 *             .appName("myapp")
 *             .bindingName("mybinding")
 *             .properties(BindingResourcePropertiesArgs.builder()
 *                 .bindingParameters(Map.ofEntries(
 *                     Map.entry("apiType", "SQL"),
 *                     Map.entry("databaseName", "db1")
 *                 ))
 *                 .key("xxxx")
 *                 .resourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.DocumentDB/databaseAccounts/my-cosmosdb-1")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Binding mybinding /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/bindings/{bindingName}
 * ```
 * @property appName The name of the App resource.
 * @property bindingName The name of the Binding resource.
 * @property properties Properties of the Binding resource
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class BindingArgs(
    public val appName: Output<String>? = null,
    public val bindingName: Output<String>? = null,
    public val properties: Output<BindingResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.BindingArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.BindingArgs =
        com.pulumi.azurenative.appplatform.BindingArgs.builder()
            .appName(appName?.applyValue({ args0 -> args0 }))
            .bindingName(bindingName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BindingArgs].
 */
@PulumiTagMarker
public class BindingArgsBuilder internal constructor() {
    private var appName: Output<String>? = null

    private var bindingName: Output<String>? = null

    private var properties: Output<BindingResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of the App resource.
     */
    @JvmName("ciaqrblbxocbpbnr")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value The name of the Binding resource.
     */
    @JvmName("biidtpdetmtyqvlu")
    public suspend fun bindingName(`value`: Output<String>) {
        this.bindingName = value
    }

    /**
     * @param value Properties of the Binding resource
     */
    @JvmName("icpvxnyyaoukovey")
    public suspend fun properties(`value`: Output<BindingResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("rpxncpqajqfmddpp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("swwrtmohqqgfoivt")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the App resource.
     */
    @JvmName("wgtqsgbmfsmbjhjf")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value The name of the Binding resource.
     */
    @JvmName("abcdgollilnqoupv")
    public suspend fun bindingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindingName = mapped
    }

    /**
     * @param value Properties of the Binding resource
     */
    @JvmName("arkrybjccjggtfdu")
    public suspend fun properties(`value`: BindingResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the Binding resource
     */
    @JvmName("opgoxgqpbfuqpkmu")
    public suspend fun properties(argument: suspend BindingResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BindingResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("wmcgtbmkkykroxqt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("aebxuurayetjbixn")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): BindingArgs = BindingArgs(
        appName = appName,
        bindingName = bindingName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
