@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.BuilderPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.BuilderPropertiesResponse.Companion.toKotlin as builderPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [BuildServiceBuilder].
 */
@PulumiTagMarker
public class BuildServiceBuilderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BuildServiceBuilderArgs = BuildServiceBuilderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BuildServiceBuilderArgsBuilder.() -> Unit) {
        val builder = BuildServiceBuilderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BuildServiceBuilder {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.BuildServiceBuilder(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BuildServiceBuilder(builtJavaResource)
    }
}

/**
 * KPack Builder resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### BuildServiceBuilder_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var buildServiceBuilder = new AzureNative.AppPlatform.BuildServiceBuilder("buildServiceBuilder", new()
 *     {
 *         BuildServiceName = "default",
 *         BuilderName = "mybuilder",
 *         Properties = new AzureNative.AppPlatform.Inputs.BuilderPropertiesArgs
 *         {
 *             BuildpackGroups = new[]
 *             {
 *                 new AzureNative.AppPlatform.Inputs.BuildpacksGroupPropertiesArgs
 *                 {
 *                     Buildpacks = new[]
 *                     {
 *                         new AzureNative.AppPlatform.Inputs.BuildpackPropertiesArgs
 *                         {
 *                             Id = "tanzu-buildpacks/java-azure",
 *                         },
 *                     },
 *                     Name = "mix",
 *                 },
 *             },
 *             Stack = new AzureNative.AppPlatform.Inputs.StackPropertiesArgs
 *             {
 *                 Id = "io.buildpacks.stacks.bionic",
 *                 Version = "base",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewBuildServiceBuilder(ctx, "buildServiceBuilder", &appplatform.BuildServiceBuilderArgs{
 * 			BuildServiceName: pulumi.String("default"),
 * 			BuilderName:      pulumi.String("mybuilder"),
 * 			Properties: &appplatform.BuilderPropertiesArgs{
 * 				BuildpackGroups: appplatform.BuildpacksGroupPropertiesArray{
 * 					&appplatform.BuildpacksGroupPropertiesArgs{
 * 						Buildpacks: appplatform.BuildpackPropertiesArray{
 * 							&appplatform.BuildpackPropertiesArgs{
 * 								Id: pulumi.String("tanzu-buildpacks/java-azure"),
 * 							},
 * 						},
 * 						Name: pulumi.String("mix"),
 * 					},
 * 				},
 * 				Stack: &appplatform.StackPropertiesArgs{
 * 					Id:      pulumi.String("io.buildpacks.stacks.bionic"),
 * 					Version: pulumi.String("base"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.BuildServiceBuilder;
 * import com.pulumi.azurenative.appplatform.BuildServiceBuilderArgs;
 * import com.pulumi.azurenative.appplatform.inputs.BuilderPropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.StackPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var buildServiceBuilder = new BuildServiceBuilder("buildServiceBuilder", BuildServiceBuilderArgs.builder()
 *             .buildServiceName("default")
 *             .builderName("mybuilder")
 *             .properties(BuilderPropertiesArgs.builder()
 *                 .buildpackGroups(BuildpacksGroupPropertiesArgs.builder()
 *                     .buildpacks(BuildpackPropertiesArgs.builder()
 *                         .id("tanzu-buildpacks/java-azure")
 *                         .build())
 *                     .name("mix")
 *                     .build())
 *                 .stack(StackPropertiesArgs.builder()
 *                     .id("io.buildpacks.stacks.bionic")
 *                     .version("base")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:BuildServiceBuilder mybuilder /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builders/{builderName}
 * ```
 */
public class BuildServiceBuilder internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.BuildServiceBuilder,
) : KotlinCustomResource(javaResource, BuildServiceBuilderMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Property of the Builder resource.
     */
    public val properties: Output<BuilderPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                builderPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BuildServiceBuilderMapper : ResourceMapper<BuildServiceBuilder> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.BuildServiceBuilder::class == javaResource::class

    override fun map(javaResource: Resource): BuildServiceBuilder = BuildServiceBuilder(
        javaResource
            as com.pulumi.azurenative.appplatform.BuildServiceBuilder,
    )
}

/**
 * @see [BuildServiceBuilder].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BuildServiceBuilder].
 */
public suspend fun buildServiceBuilder(
    name: String,
    block: suspend BuildServiceBuilderResourceBuilder.() -> Unit,
): BuildServiceBuilder {
    val builder = BuildServiceBuilderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BuildServiceBuilder].
 * @param name The _unique_ name of the resulting resource.
 */
public fun buildServiceBuilder(name: String): BuildServiceBuilder {
    val builder = BuildServiceBuilderResourceBuilder()
    builder.name(name)
    return builder.build()
}
