@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.BuildpackBindingPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.BuildpackBindingPropertiesResponse.Companion.toKotlin as buildpackBindingPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [BuildpackBinding].
 */
@PulumiTagMarker
public class BuildpackBindingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BuildpackBindingArgs = BuildpackBindingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BuildpackBindingArgsBuilder.() -> Unit) {
        val builder = BuildpackBindingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BuildpackBinding {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.BuildpackBinding(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BuildpackBinding(builtJavaResource)
    }
}

/**
 * Buildpack Binding Resource object
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### BuildpackBinding_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var buildpackBinding = new AzureNative.AppPlatform.BuildpackBinding("buildpackBinding", new()
 *     {
 *         BuildServiceName = "default",
 *         BuilderName = "default",
 *         BuildpackBindingName = "myBuildpackBinding",
 *         Properties = new AzureNative.AppPlatform.Inputs.BuildpackBindingPropertiesArgs
 *         {
 *             BindingType = AzureNative.AppPlatform.BindingType.ApplicationInsights,
 *             LaunchProperties = new AzureNative.AppPlatform.Inputs.BuildpackBindingLaunchPropertiesArgs
 *             {
 *                 Properties =
 *                 {
 *                     { "abc", "def" },
 *                     { "any-string", "any-string" },
 *                     { "sampling-rate", "12.0" },
 *                 },
 *                 Secrets =
 *                 {
 *                     { "connection-string", "XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX" },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewBuildpackBinding(ctx, "buildpackBinding", &appplatform.BuildpackBindingArgs{
 * 			BuildServiceName:     pulumi.String("default"),
 * 			BuilderName:          pulumi.String("default"),
 * 			BuildpackBindingName: pulumi.String("myBuildpackBinding"),
 * 			Properties: &appplatform.BuildpackBindingPropertiesArgs{
 * 				BindingType: pulumi.String(appplatform.BindingTypeApplicationInsights),
 * 				LaunchProperties: &appplatform.BuildpackBindingLaunchPropertiesArgs{
 * 					Properties: pulumi.StringMap{
 * 						"abc":           pulumi.String("def"),
 * 						"any-string":    pulumi.String("any-string"),
 * 						"sampling-rate": pulumi.String("12.0"),
 * 					},
 * 					Secrets: pulumi.StringMap{
 * 						"connection-string": pulumi.String("XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.BuildpackBinding;
 * import com.pulumi.azurenative.appplatform.BuildpackBindingArgs;
 * import com.pulumi.azurenative.appplatform.inputs.BuildpackBindingPropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.BuildpackBindingLaunchPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var buildpackBinding = new BuildpackBinding("buildpackBinding", BuildpackBindingArgs.builder()
 *             .buildServiceName("default")
 *             .builderName("default")
 *             .buildpackBindingName("myBuildpackBinding")
 *             .properties(BuildpackBindingPropertiesArgs.builder()
 *                 .bindingType("ApplicationInsights")
 *                 .launchProperties(BuildpackBindingLaunchPropertiesArgs.builder()
 *                     .properties(Map.ofEntries(
 *                         Map.entry("abc", "def"),
 *                         Map.entry("any-string", "any-string"),
 *                         Map.entry("sampling-rate", "12.0")
 *                     ))
 *                     .secrets(Map.of("connection-string", "XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX"))
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:BuildpackBinding myBuildpackBinding /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builders/{builderName}/buildpackBindings/{buildpackBindingName}
 * ```
 */
public class BuildpackBinding internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.BuildpackBinding,
) : KotlinCustomResource(javaResource, BuildpackBindingMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of a buildpack binding
     */
    public val properties: Output<BuildpackBindingPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                buildpackBindingPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BuildpackBindingMapper : ResourceMapper<BuildpackBinding> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.BuildpackBinding::class == javaResource::class

    override fun map(javaResource: Resource): BuildpackBinding = BuildpackBinding(
        javaResource as
            com.pulumi.azurenative.appplatform.BuildpackBinding,
    )
}

/**
 * @see [BuildpackBinding].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BuildpackBinding].
 */
public suspend fun buildpackBinding(
    name: String,
    block: suspend BuildpackBindingResourceBuilder.() -> Unit,
): BuildpackBinding {
    val builder = BuildpackBindingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BuildpackBinding].
 * @param name The _unique_ name of the resulting resource.
 */
public fun buildpackBinding(name: String): BuildpackBinding {
    val builder = BuildpackBindingResourceBuilder()
    builder.name(name)
    return builder.build()
}
