@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.ConfigServerPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.ConfigServerPropertiesResponse.Companion.toKotlin as configServerPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConfigServer].
 */
@PulumiTagMarker
public class ConfigServerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigServerArgs = ConfigServerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigServerArgsBuilder.() -> Unit) {
        val builder = ConfigServerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConfigServer {
        val builtJavaResource = com.pulumi.azurenative.appplatform.ConfigServer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConfigServer(builtJavaResource)
    }
}

/**
 * Config Server resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### ConfigServers_UpdatePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configServer = new AzureNative.AppPlatform.ConfigServer("configServer", new()
 *     {
 *         Properties = new AzureNative.AppPlatform.Inputs.ConfigServerPropertiesArgs
 *         {
 *             ConfigServer = new AzureNative.AppPlatform.Inputs.ConfigServerSettingsArgs
 *             {
 *                 GitProperty = new AzureNative.AppPlatform.Inputs.ConfigServerGitPropertyArgs
 *                 {
 *                     Label = "master",
 *                     SearchPaths = new[]
 *                     {
 *                         "/",
 *                     },
 *                     Uri = "https://github.com/fake-user/fake-repository.git",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewConfigServer(ctx, "configServer", &appplatform.ConfigServerArgs{
 * 			Properties: &appplatform.ConfigServerPropertiesArgs{
 * 				ConfigServer: &appplatform.ConfigServerSettingsArgs{
 * 					GitProperty: &appplatform.ConfigServerGitPropertyArgs{
 * 						Label: pulumi.String("master"),
 * 						SearchPaths: pulumi.StringArray{
 * 							pulumi.String("/"),
 * 						},
 * 						Uri: pulumi.String("https://github.com/fake-user/fake-repository.git"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ConfigServer;
 * import com.pulumi.azurenative.appplatform.ConfigServerArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ConfigServerPropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ConfigServerSettingsArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ConfigServerGitPropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configServer = new ConfigServer("configServer", ConfigServerArgs.builder()
 *             .properties(ConfigServerPropertiesArgs.builder()
 *                 .configServer(ConfigServerSettingsArgs.builder()
 *                     .gitProperty(ConfigServerGitPropertyArgs.builder()
 *                         .label("master")
 *                         .searchPaths("/")
 *                         .uri("https://github.com/fake-user/fake-repository.git")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ### ConfigServers_UpdatePut_Consumption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configServer = new AzureNative.AppPlatform.ConfigServer("configServer", new()
 *     {
 *         Properties = new AzureNative.AppPlatform.Inputs.ConfigServerPropertiesArgs
 *         {
 *             ConfigServer = new AzureNative.AppPlatform.Inputs.ConfigServerSettingsArgs
 *             {
 *                 GitProperty = new AzureNative.AppPlatform.Inputs.ConfigServerGitPropertyArgs
 *                 {
 *                     Label = "master",
 *                     SearchPaths = new[]
 *                     {
 *                         "/",
 *                     },
 *                     Uri = "https://github.com/fake-user/fake-repository.git",
 *                 },
 *             },
 *             EnabledState = AzureNative.AppPlatform.ConfigServerEnabledState.Enabled,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewConfigServer(ctx, "configServer", &appplatform.ConfigServerArgs{
 * 			Properties: &appplatform.ConfigServerPropertiesArgs{
 * 				ConfigServer: &appplatform.ConfigServerSettingsArgs{
 * 					GitProperty: &appplatform.ConfigServerGitPropertyArgs{
 * 						Label: pulumi.String("master"),
 * 						SearchPaths: pulumi.StringArray{
 * 							pulumi.String("/"),
 * 						},
 * 						Uri: pulumi.String("https://github.com/fake-user/fake-repository.git"),
 * 					},
 * 				},
 * 				EnabledState: pulumi.String(appplatform.ConfigServerEnabledStateEnabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ConfigServer;
 * import com.pulumi.azurenative.appplatform.ConfigServerArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ConfigServerPropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ConfigServerSettingsArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ConfigServerGitPropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configServer = new ConfigServer("configServer", ConfigServerArgs.builder()
 *             .properties(ConfigServerPropertiesArgs.builder()
 *                 .configServer(ConfigServerSettingsArgs.builder()
 *                     .gitProperty(ConfigServerGitPropertyArgs.builder()
 *                         .label("master")
 *                         .searchPaths("/")
 *                         .uri("https://github.com/fake-user/fake-repository.git")
 *                         .build())
 *                     .build())
 *                 .enabledState("Enabled")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:ConfigServer default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configServers/default
 * ```
 */
public class ConfigServer internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.ConfigServer,
) : KotlinCustomResource(javaResource, ConfigServerMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the Config Server resource
     */
    public val properties: Output<ConfigServerPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                configServerPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigServerMapper : ResourceMapper<ConfigServer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.ConfigServer::class == javaResource::class

    override fun map(javaResource: Resource): ConfigServer = ConfigServer(
        javaResource as
            com.pulumi.azurenative.appplatform.ConfigServer,
    )
}

/**
 * @see [ConfigServer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigServer].
 */
public suspend fun configServer(
    name: String,
    block: suspend ConfigServerResourceBuilder.() -> Unit,
): ConfigServer {
    val builder = ConfigServerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigServer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configServer(name: String): ConfigServer {
    val builder = ConfigServerResourceBuilder()
    builder.name(name)
    return builder.build()
}
