@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.ConfigurationServiceArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.ConfigurationServicePropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.ConfigurationServicePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Application Configuration Service resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### ConfigurationServices_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationService = new AzureNative.AppPlatform.ConfigurationService("configurationService", new()
 *     {
 *         ConfigurationServiceName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.ConfigurationServicePropertiesArgs
 *         {
 *             Settings = new AzureNative.AppPlatform.Inputs.ConfigurationServiceSettingsArgs
 *             {
 *                 GitProperty = new AzureNative.AppPlatform.Inputs.ConfigurationServiceGitPropertyArgs
 *                 {
 *                     Repositories = new[]
 *                     {
 *                         new AzureNative.AppPlatform.Inputs.ConfigurationServiceGitRepositoryArgs
 *                         {
 *                             Label = "master",
 *                             Name = "fake",
 *                             Patterns = new[]
 *                             {
 *                                 "app/dev",
 *                             },
 *                             Uri = "https://github.com/fake-user/fake-repository",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewConfigurationService(ctx, "configurationService", &appplatform.ConfigurationServiceArgs{
 * 			ConfigurationServiceName: pulumi.String("default"),
 * 			Properties: &appplatform.ConfigurationServicePropertiesArgs{
 * 				Settings: &appplatform.ConfigurationServiceSettingsArgs{
 * 					GitProperty: &appplatform.ConfigurationServiceGitPropertyArgs{
 * 						Repositories: appplatform.ConfigurationServiceGitRepositoryArray{
 * 							&appplatform.ConfigurationServiceGitRepositoryArgs{
 * 								Label: pulumi.String("master"),
 * 								Name:  pulumi.String("fake"),
 * 								Patterns: pulumi.StringArray{
 * 									pulumi.String("app/dev"),
 * 								},
 * 								Uri: pulumi.String("https://github.com/fake-user/fake-repository"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ConfigurationService;
 * import com.pulumi.azurenative.appplatform.ConfigurationServiceArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ConfigurationServicePropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceSettingsArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceGitPropertyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationService = new ConfigurationService("configurationService", ConfigurationServiceArgs.builder()
 *             .configurationServiceName("default")
 *             .properties(ConfigurationServicePropertiesArgs.builder()
 *                 .settings(ConfigurationServiceSettingsArgs.builder()
 *                     .gitProperty(ConfigurationServiceGitPropertyArgs.builder()
 *                         .repositories(ConfigurationServiceGitRepositoryArgs.builder()
 *                             .label("master")
 *                             .name("fake")
 *                             .patterns("app/dev")
 *                             .uri("https://github.com/fake-user/fake-repository")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:ConfigurationService default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}
 * ```
 * @property configurationServiceName The name of Application Configuration Service.
 * @property properties Application Configuration Service properties payload
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class ConfigurationServiceArgs(
    public val configurationServiceName: Output<String>? = null,
    public val properties: Output<ConfigurationServicePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.ConfigurationServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.ConfigurationServiceArgs =
        com.pulumi.azurenative.appplatform.ConfigurationServiceArgs.builder()
            .configurationServiceName(configurationServiceName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationServiceArgs].
 */
@PulumiTagMarker
public class ConfigurationServiceArgsBuilder internal constructor() {
    private var configurationServiceName: Output<String>? = null

    private var properties: Output<ConfigurationServicePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of Application Configuration Service.
     */
    @JvmName("qfqlgagnjnfxggrv")
    public suspend fun configurationServiceName(`value`: Output<String>) {
        this.configurationServiceName = value
    }

    /**
     * @param value Application Configuration Service properties payload
     */
    @JvmName("fihncfbghgsfycew")
    public suspend fun properties(`value`: Output<ConfigurationServicePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("plenvjpxuifcbutr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("mitmnfvifvgoohne")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of Application Configuration Service.
     */
    @JvmName("ooimkjmxxkkahqmj")
    public suspend fun configurationServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationServiceName = mapped
    }

    /**
     * @param value Application Configuration Service properties payload
     */
    @JvmName("cmodgwwrdisldbnb")
    public suspend fun properties(`value`: ConfigurationServicePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Application Configuration Service properties payload
     */
    @JvmName("qvbtnpfjackhnpun")
    public suspend
    fun properties(argument: suspend ConfigurationServicePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationServicePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("vwmdyxsnucrhsdkg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("dqynmsfeabojhuuj")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ConfigurationServiceArgs = ConfigurationServiceArgs(
        configurationServiceName = configurationServiceName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
