@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.DeploymentResourcePropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.DeploymentResourcePropertiesResponse.Companion.toKotlin as deploymentResourcePropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Deployment].
 */
@PulumiTagMarker
public class DeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentArgs = DeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentArgsBuilder.() -> Unit) {
        val builder = DeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Deployment {
        val builtJavaResource = com.pulumi.azurenative.appplatform.Deployment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Deployment(builtJavaResource)
    }
}

/**
 * Deployment resource payload
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### Deployments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.AppPlatform.Deployment("deployment", new()
 *     {
 *         AppName = "myapp",
 *         DeploymentName = "mydeployment",
 *         Properties = new AzureNative.AppPlatform.Inputs.DeploymentResourcePropertiesArgs
 *         {
 *             DeploymentSettings = new AzureNative.AppPlatform.Inputs.DeploymentSettingsArgs
 *             {
 *                 AddonConfigs =
 *                 {
 *                     { "ApplicationConfigurationService", new Dictionary<string, object?>
 *                     {
 *                         ["patterns"] = new[]
 *                         {
 *                             "mypattern",
 *                         },
 *                     } },
 *                 },
 *                 Apms = new[]
 *                 {
 *                     new AzureNative.AppPlatform.Inputs.ApmReferenceArgs
 *                     {
 *                         ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights",
 *                     },
 *                 },
 *                 EnvironmentVariables =
 *                 {
 *                     { "env", "test" },
 *                 },
 *                 LivenessProbe = new AzureNative.AppPlatform.Inputs.ProbeArgs
 *                 {
 *                     DisableProbe = false,
 *                     FailureThreshold = 3,
 *                     InitialDelaySeconds = 30,
 *                     PeriodSeconds = 10,
 *                     ProbeAction = new AzureNative.AppPlatform.Inputs.HTTPGetActionArgs
 *                     {
 *                         Path = "/health",
 *                         Scheme = AzureNative.AppPlatform.HTTPSchemeType.HTTP,
 *                         Type = "HTTPGetAction",
 *                     },
 *                 },
 *                 ReadinessProbe = new AzureNative.AppPlatform.Inputs.ProbeArgs
 *                 {
 *                     DisableProbe = false,
 *                     FailureThreshold = 3,
 *                     InitialDelaySeconds = 30,
 *                     PeriodSeconds = 10,
 *                     ProbeAction = new AzureNative.AppPlatform.Inputs.HTTPGetActionArgs
 *                     {
 *                         Path = "/health",
 *                         Scheme = AzureNative.AppPlatform.HTTPSchemeType.HTTP,
 *                         Type = "HTTPGetAction",
 *                     },
 *                 },
 *                 ResourceRequests = new AzureNative.AppPlatform.Inputs.ResourceRequestsArgs
 *                 {
 *                     Cpu = "1000m",
 *                     Memory = "3Gi",
 *                 },
 *                 TerminationGracePeriodSeconds = 30,
 *             },
 *             Source = new AzureNative.AppPlatform.Inputs.SourceUploadedUserSourceInfoArgs
 *             {
 *                 ArtifactSelector = "sub-module-1",
 *                 RelativePath = "resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc",
 *                 Type = "Source",
 *                 Version = "1.0",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Capacity = 1,
 *             Name = "S0",
 *             Tier = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewDeployment(ctx, "deployment", &appplatform.DeploymentArgs{
 * 			AppName:        pulumi.String("myapp"),
 * 			DeploymentName: pulumi.String("mydeployment"),
 * 			Properties: &appplatform.DeploymentResourcePropertiesArgs{
 * 				DeploymentSettings: &appplatform.DeploymentSettingsArgs{
 * 					AddonConfigs: pulumi.Map{
 * 						"ApplicationConfigurationService": pulumi.Any(map[string]interface{}{
 * 							"patterns": []string{
 * 								"mypattern",
 * 							},
 * 						}),
 * 					},
 * 					Apms: appplatform.ApmReferenceArray{
 * 						&appplatform.ApmReferenceArgs{
 * 							ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights"),
 * 						},
 * 					},
 * 					EnvironmentVariables: pulumi.StringMap{
 * 						"env": pulumi.String("test"),
 * 					},
 * 					LivenessProbe: &appplatform.ProbeArgs{
 * 						DisableProbe:        pulumi.Bool(false),
 * 						FailureThreshold:    pulumi.Int(3),
 * 						InitialDelaySeconds: pulumi.Int(30),
 * 						PeriodSeconds:       pulumi.Int(10),
 * 						ProbeAction: appplatform.HTTPGetAction{
 * 							Path:   "/health",
 * 							Scheme: appplatform.HTTPSchemeTypeHTTP,
 * 							Type:   "HTTPGetAction",
 * 						},
 * 					},
 * 					ReadinessProbe: &appplatform.ProbeArgs{
 * 						DisableProbe:        pulumi.Bool(false),
 * 						FailureThreshold:    pulumi.Int(3),
 * 						InitialDelaySeconds: pulumi.Int(30),
 * 						PeriodSeconds:       pulumi.Int(10),
 * 						ProbeAction: appplatform.HTTPGetAction{
 * 							Path:   "/health",
 * 							Scheme: appplatform.HTTPSchemeTypeHTTP,
 * 							Type:   "HTTPGetAction",
 * 						},
 * 					},
 * 					ResourceRequests: &appplatform.ResourceRequestsArgs{
 * 						Cpu:    pulumi.String("1000m"),
 * 						Memory: pulumi.String("3Gi"),
 * 					},
 * 					TerminationGracePeriodSeconds: pulumi.Int(30),
 * 				},
 * 				Source: appplatform.SourceUploadedUserSourceInfo{
 * 					ArtifactSelector: "sub-module-1",
 * 					RelativePath:     "resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc",
 * 					Type:             "Source",
 * 					Version:          "1.0",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("S0"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Deployment;
 * import com.pulumi.azurenative.appplatform.DeploymentArgs;
 * import com.pulumi.azurenative.appplatform.inputs.DeploymentResourcePropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.DeploymentSettingsArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ProbeArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ResourceRequestsArgs;
 * import com.pulumi.azurenative.appplatform.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .appName("myapp")
 *             .deploymentName("mydeployment")
 *             .properties(DeploymentResourcePropertiesArgs.builder()
 *                 .deploymentSettings(DeploymentSettingsArgs.builder()
 *                     .addonConfigs(Map.of("ApplicationConfigurationService", Map.of("patterns", "mypattern")))
 *                     .apms(ApmReferenceArgs.builder()
 *                         .resourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights")
 *                         .build())
 *                     .environmentVariables(Map.of("env", "test"))
 *                     .livenessProbe(ProbeArgs.builder()
 *                         .disableProbe(false)
 *                         .failureThreshold(3)
 *                         .initialDelaySeconds(30)
 *                         .periodSeconds(10)
 *                         .probeAction(HTTPGetActionArgs.builder()
 *                             .path("/health")
 *                             .scheme("HTTP")
 *                             .type("HTTPGetAction")
 *                             .build())
 *                         .build())
 *                     .readinessProbe(ProbeArgs.builder()
 *                         .disableProbe(false)
 *                         .failureThreshold(3)
 *                         .initialDelaySeconds(30)
 *                         .periodSeconds(10)
 *                         .probeAction(HTTPGetActionArgs.builder()
 *                             .path("/health")
 *                             .scheme("HTTP")
 *                             .type("HTTPGetAction")
 *                             .build())
 *                         .build())
 *                     .resourceRequests(ResourceRequestsArgs.builder()
 *                         .cpu("1000m")
 *                         .memory("3Gi")
 *                         .build())
 *                     .terminationGracePeriodSeconds(30)
 *                     .build())
 *                 .source(BuildResultUserSourceInfoArgs.builder()
 *                     .artifactSelector("sub-module-1")
 *                     .relativePath("resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc")
 *                     .type("Source")
 *                     .version("1.0")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(SkuArgs.builder()
 *                 .capacity(1)
 *                 .name("S0")
 *                 .tier("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Deployments_CreateOrUpdate_CustomContainer
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.AppPlatform.Deployment("deployment", new()
 *     {
 *         AppName = "myapp",
 *         DeploymentName = "mydeployment",
 *         Properties = new AzureNative.AppPlatform.Inputs.DeploymentResourcePropertiesArgs
 *         {
 *             DeploymentSettings = new AzureNative.AppPlatform.Inputs.DeploymentSettingsArgs
 *             {
 *                 EnvironmentVariables =
 *                 {
 *                     { "env", "test" },
 *                 },
 *                 LivenessProbe = new AzureNative.AppPlatform.Inputs.ProbeArgs
 *                 {
 *                     DisableProbe = false,
 *                     FailureThreshold = 3,
 *                     InitialDelaySeconds = 30,
 *                     PeriodSeconds = 10,
 *                     ProbeAction = new AzureNative.AppPlatform.Inputs.HTTPGetActionArgs
 *                     {
 *                         Path = "/health",
 *                         Scheme = AzureNative.AppPlatform.HTTPSchemeType.HTTP,
 *                         Type = "HTTPGetAction",
 *                     },
 *                 },
 *                 ReadinessProbe = new AzureNative.AppPlatform.Inputs.ProbeArgs
 *                 {
 *                     DisableProbe = false,
 *                     FailureThreshold = 3,
 *                     InitialDelaySeconds = 30,
 *                     PeriodSeconds = 10,
 *                     ProbeAction = new AzureNative.AppPlatform.Inputs.HTTPGetActionArgs
 *                     {
 *                         Path = "/health",
 *                         Scheme = AzureNative.AppPlatform.HTTPSchemeType.HTTP,
 *                         Type = "HTTPGetAction",
 *                     },
 *                 },
 *                 ResourceRequests = new AzureNative.AppPlatform.Inputs.ResourceRequestsArgs
 *                 {
 *                     Cpu = "1000m",
 *                     Memory = "3Gi",
 *                 },
 *                 TerminationGracePeriodSeconds = 30,
 *             },
 *             Source = new AzureNative.AppPlatform.Inputs.CustomContainerUserSourceInfoArgs
 *             {
 *                 CustomContainer = new AzureNative.AppPlatform.Inputs.CustomContainerArgs
 *                 {
 *                     Args = new[]
 *                     {
 *                         "-c",
 *                         "while true; do echo hello; sleep 10;done",
 *                     },
 *                     Command = new[]
 *                     {
 *                         "/bin/sh",
 *                     },
 *                     ContainerImage = "myContainerImage:v1",
 *                     ImageRegistryCredential = new AzureNative.AppPlatform.Inputs.ImageRegistryCredentialArgs
 *                     {
 *                         Password = "myPassword",
 *                         Username = "myUsername",
 *                     },
 *                     LanguageFramework = "springboot",
 *                     Server = "myacr.azurecr.io",
 *                 },
 *                 Type = "Container",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewDeployment(ctx, "deployment", &appplatform.DeploymentArgs{
 * 			AppName:        pulumi.String("myapp"),
 * 			DeploymentName: pulumi.String("mydeployment"),
 * 			Properties: &appplatform.DeploymentResourcePropertiesArgs{
 * 				DeploymentSettings: &appplatform.DeploymentSettingsArgs{
 * 					EnvironmentVariables: pulumi.StringMap{
 * 						"env": pulumi.String("test"),
 * 					},
 * 					LivenessProbe: &appplatform.ProbeArgs{
 * 						DisableProbe:        pulumi.Bool(false),
 * 						FailureThreshold:    pulumi.Int(3),
 * 						InitialDelaySeconds: pulumi.Int(30),
 * 						PeriodSeconds:       pulumi.Int(10),
 * 						ProbeAction: appplatform.HTTPGetAction{
 * 							Path:   "/health",
 * 							Scheme: appplatform.HTTPSchemeTypeHTTP,
 * 							Type:   "HTTPGetAction",
 * 						},
 * 					},
 * 					ReadinessProbe: &appplatform.ProbeArgs{
 * 						DisableProbe:        pulumi.Bool(false),
 * 						FailureThreshold:    pulumi.Int(3),
 * 						InitialDelaySeconds: pulumi.Int(30),
 * 						PeriodSeconds:       pulumi.Int(10),
 * 						ProbeAction: appplatform.HTTPGetAction{
 * 							Path:   "/health",
 * 							Scheme: appplatform.HTTPSchemeTypeHTTP,
 * 							Type:   "HTTPGetAction",
 * 						},
 * 					},
 * 					ResourceRequests: &appplatform.ResourceRequestsArgs{
 * 						Cpu:    pulumi.String("1000m"),
 * 						Memory: pulumi.String("3Gi"),
 * 					},
 * 					TerminationGracePeriodSeconds: pulumi.Int(30),
 * 				},
 * 				Source: appplatform.CustomContainerUserSourceInfo{
 * 					CustomContainer: appplatform.CustomContainer{
 * 						Args: []string{
 * 							"-c",
 * 							"while true; do echo hello; sleep 10;done",
 * 						},
 * 						Command: []string{
 * 							"/bin/sh",
 * 						},
 * 						ContainerImage: "myContainerImage:v1",
 * 						ImageRegistryCredential: appplatform.ImageRegistryCredential{
 * 							Password: "myPassword",
 * 							Username: "myUsername",
 * 						},
 * 						LanguageFramework: "springboot",
 * 						Server:            "myacr.azurecr.io",
 * 					},
 * 					Type: "Container",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Deployment;
 * import com.pulumi.azurenative.appplatform.DeploymentArgs;
 * import com.pulumi.azurenative.appplatform.inputs.DeploymentResourcePropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.DeploymentSettingsArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ProbeArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ResourceRequestsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .appName("myapp")
 *             .deploymentName("mydeployment")
 *             .properties(DeploymentResourcePropertiesArgs.builder()
 *                 .deploymentSettings(DeploymentSettingsArgs.builder()
 *                     .environmentVariables(Map.of("env", "test"))
 *                     .livenessProbe(ProbeArgs.builder()
 *                         .disableProbe(false)
 *                         .failureThreshold(3)
 *                         .initialDelaySeconds(30)
 *                         .periodSeconds(10)
 *                         .probeAction(HTTPGetActionArgs.builder()
 *                             .path("/health")
 *                             .scheme("HTTP")
 *                             .type("HTTPGetAction")
 *                             .build())
 *                         .build())
 *                     .readinessProbe(ProbeArgs.builder()
 *                         .disableProbe(false)
 *                         .failureThreshold(3)
 *                         .initialDelaySeconds(30)
 *                         .periodSeconds(10)
 *                         .probeAction(HTTPGetActionArgs.builder()
 *                             .path("/health")
 *                             .scheme("HTTP")
 *                             .type("HTTPGetAction")
 *                             .build())
 *                         .build())
 *                     .resourceRequests(ResourceRequestsArgs.builder()
 *                         .cpu("1000m")
 *                         .memory("3Gi")
 *                         .build())
 *                     .terminationGracePeriodSeconds(30)
 *                     .build())
 *                 .source(CustomContainerUserSourceInfoArgs.builder()
 *                     .customContainer(CustomContainerArgs.builder()
 *                         .args(
 *                             "-c",
 *                             "while true; do echo hello; sleep 10;done")
 *                         .command("/bin/sh")
 *                         .containerImage("myContainerImage:v1")
 *                         .imageRegistryCredential(ImageRegistryCredentialArgs.builder()
 *                             .password("myPassword")
 *                             .username("myUsername")
 *                             .build())
 *                         .languageFramework("springboot")
 *                         .server("myacr.azurecr.io")
 *                         .build())
 *                     .type("Container")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Deployment mydeployment /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}
 * ```
 */
public class Deployment internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.Deployment,
) : KotlinCustomResource(javaResource, DeploymentMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the Deployment resource
     */
    public val properties: Output<DeploymentResourcePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                deploymentResourcePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Sku of the Deployment resource
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DeploymentMapper : ResourceMapper<Deployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.Deployment::class == javaResource::class

    override fun map(javaResource: Resource): Deployment = Deployment(
        javaResource as
            com.pulumi.azurenative.appplatform.Deployment,
    )
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Deployment].
 */
public suspend fun deployment(name: String, block: suspend DeploymentResourceBuilder.() -> Unit):
    Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deployment(name: String): Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
