@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.DeploymentArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.DeploymentResourcePropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.DeploymentResourcePropertiesArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Deployment resource payload
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### Deployments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.AppPlatform.Deployment("deployment", new()
 *     {
 *         AppName = "myapp",
 *         DeploymentName = "mydeployment",
 *         Properties = new AzureNative.AppPlatform.Inputs.DeploymentResourcePropertiesArgs
 *         {
 *             DeploymentSettings = new AzureNative.AppPlatform.Inputs.DeploymentSettingsArgs
 *             {
 *                 AddonConfigs =
 *                 {
 *                     { "ApplicationConfigurationService", new Dictionary<string, object?>
 *                     {
 *                         ["patterns"] = new[]
 *                         {
 *                             "mypattern",
 *                         },
 *                     } },
 *                 },
 *                 Apms = new[]
 *                 {
 *                     new AzureNative.AppPlatform.Inputs.ApmReferenceArgs
 *                     {
 *                         ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights",
 *                     },
 *                 },
 *                 EnvironmentVariables =
 *                 {
 *                     { "env", "test" },
 *                 },
 *                 LivenessProbe = new AzureNative.AppPlatform.Inputs.ProbeArgs
 *                 {
 *                     DisableProbe = false,
 *                     FailureThreshold = 3,
 *                     InitialDelaySeconds = 30,
 *                     PeriodSeconds = 10,
 *                     ProbeAction = new AzureNative.AppPlatform.Inputs.HTTPGetActionArgs
 *                     {
 *                         Path = "/health",
 *                         Scheme = AzureNative.AppPlatform.HTTPSchemeType.HTTP,
 *                         Type = "HTTPGetAction",
 *                     },
 *                 },
 *                 ReadinessProbe = new AzureNative.AppPlatform.Inputs.ProbeArgs
 *                 {
 *                     DisableProbe = false,
 *                     FailureThreshold = 3,
 *                     InitialDelaySeconds = 30,
 *                     PeriodSeconds = 10,
 *                     ProbeAction = new AzureNative.AppPlatform.Inputs.HTTPGetActionArgs
 *                     {
 *                         Path = "/health",
 *                         Scheme = AzureNative.AppPlatform.HTTPSchemeType.HTTP,
 *                         Type = "HTTPGetAction",
 *                     },
 *                 },
 *                 ResourceRequests = new AzureNative.AppPlatform.Inputs.ResourceRequestsArgs
 *                 {
 *                     Cpu = "1000m",
 *                     Memory = "3Gi",
 *                 },
 *                 TerminationGracePeriodSeconds = 30,
 *             },
 *             Source = new AzureNative.AppPlatform.Inputs.SourceUploadedUserSourceInfoArgs
 *             {
 *                 ArtifactSelector = "sub-module-1",
 *                 RelativePath = "resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc",
 *                 Type = "Source",
 *                 Version = "1.0",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Capacity = 1,
 *             Name = "S0",
 *             Tier = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewDeployment(ctx, "deployment", &appplatform.DeploymentArgs{
 * 			AppName:        pulumi.String("myapp"),
 * 			DeploymentName: pulumi.String("mydeployment"),
 * 			Properties: &appplatform.DeploymentResourcePropertiesArgs{
 * 				DeploymentSettings: &appplatform.DeploymentSettingsArgs{
 * 					AddonConfigs: pulumi.Map{
 * 						"ApplicationConfigurationService": pulumi.Any(map[string]interface{}{
 * 							"patterns": []string{
 * 								"mypattern",
 * 							},
 * 						}),
 * 					},
 * 					Apms: appplatform.ApmReferenceArray{
 * 						&appplatform.ApmReferenceArgs{
 * 							ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights"),
 * 						},
 * 					},
 * 					EnvironmentVariables: pulumi.StringMap{
 * 						"env": pulumi.String("test"),
 * 					},
 * 					LivenessProbe: &appplatform.ProbeArgs{
 * 						DisableProbe:        pulumi.Bool(false),
 * 						FailureThreshold:    pulumi.Int(3),
 * 						InitialDelaySeconds: pulumi.Int(30),
 * 						PeriodSeconds:       pulumi.Int(10),
 * 						ProbeAction: appplatform.HTTPGetAction{
 * 							Path:   "/health",
 * 							Scheme: appplatform.HTTPSchemeTypeHTTP,
 * 							Type:   "HTTPGetAction",
 * 						},
 * 					},
 * 					ReadinessProbe: &appplatform.ProbeArgs{
 * 						DisableProbe:        pulumi.Bool(false),
 * 						FailureThreshold:    pulumi.Int(3),
 * 						InitialDelaySeconds: pulumi.Int(30),
 * 						PeriodSeconds:       pulumi.Int(10),
 * 						ProbeAction: appplatform.HTTPGetAction{
 * 							Path:   "/health",
 * 							Scheme: appplatform.HTTPSchemeTypeHTTP,
 * 							Type:   "HTTPGetAction",
 * 						},
 * 					},
 * 					ResourceRequests: &appplatform.ResourceRequestsArgs{
 * 						Cpu:    pulumi.String("1000m"),
 * 						Memory: pulumi.String("3Gi"),
 * 					},
 * 					TerminationGracePeriodSeconds: pulumi.Int(30),
 * 				},
 * 				Source: appplatform.SourceUploadedUserSourceInfo{
 * 					ArtifactSelector: "sub-module-1",
 * 					RelativePath:     "resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc",
 * 					Type:             "Source",
 * 					Version:          "1.0",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("S0"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Deployment;
 * import com.pulumi.azurenative.appplatform.DeploymentArgs;
 * import com.pulumi.azurenative.appplatform.inputs.DeploymentResourcePropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.DeploymentSettingsArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ProbeArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ResourceRequestsArgs;
 * import com.pulumi.azurenative.appplatform.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .appName("myapp")
 *             .deploymentName("mydeployment")
 *             .properties(DeploymentResourcePropertiesArgs.builder()
 *                 .deploymentSettings(DeploymentSettingsArgs.builder()
 *                     .addonConfigs(Map.of("ApplicationConfigurationService", Map.of("patterns", "mypattern")))
 *                     .apms(ApmReferenceArgs.builder()
 *                         .resourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/apms/myappinsights")
 *                         .build())
 *                     .environmentVariables(Map.of("env", "test"))
 *                     .livenessProbe(ProbeArgs.builder()
 *                         .disableProbe(false)
 *                         .failureThreshold(3)
 *                         .initialDelaySeconds(30)
 *                         .periodSeconds(10)
 *                         .probeAction(HTTPGetActionArgs.builder()
 *                             .path("/health")
 *                             .scheme("HTTP")
 *                             .type("HTTPGetAction")
 *                             .build())
 *                         .build())
 *                     .readinessProbe(ProbeArgs.builder()
 *                         .disableProbe(false)
 *                         .failureThreshold(3)
 *                         .initialDelaySeconds(30)
 *                         .periodSeconds(10)
 *                         .probeAction(HTTPGetActionArgs.builder()
 *                             .path("/health")
 *                             .scheme("HTTP")
 *                             .type("HTTPGetAction")
 *                             .build())
 *                         .build())
 *                     .resourceRequests(ResourceRequestsArgs.builder()
 *                         .cpu("1000m")
 *                         .memory("3Gi")
 *                         .build())
 *                     .terminationGracePeriodSeconds(30)
 *                     .build())
 *                 .source(BuildResultUserSourceInfoArgs.builder()
 *                     .artifactSelector("sub-module-1")
 *                     .relativePath("resources/a172cedcae47474b615c54d510a5d84a8dea3032e958587430b413538be3f333-2019082605-e3095339-1723-44b7-8b5e-31b1003978bc")
 *                     .type("Source")
 *                     .version("1.0")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(SkuArgs.builder()
 *                 .capacity(1)
 *                 .name("S0")
 *                 .tier("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Deployments_CreateOrUpdate_CustomContainer
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.AppPlatform.Deployment("deployment", new()
 *     {
 *         AppName = "myapp",
 *         DeploymentName = "mydeployment",
 *         Properties = new AzureNative.AppPlatform.Inputs.DeploymentResourcePropertiesArgs
 *         {
 *             DeploymentSettings = new AzureNative.AppPlatform.Inputs.DeploymentSettingsArgs
 *             {
 *                 EnvironmentVariables =
 *                 {
 *                     { "env", "test" },
 *                 },
 *                 LivenessProbe = new AzureNative.AppPlatform.Inputs.ProbeArgs
 *                 {
 *                     DisableProbe = false,
 *                     FailureThreshold = 3,
 *                     InitialDelaySeconds = 30,
 *                     PeriodSeconds = 10,
 *                     ProbeAction = new AzureNative.AppPlatform.Inputs.HTTPGetActionArgs
 *                     {
 *                         Path = "/health",
 *                         Scheme = AzureNative.AppPlatform.HTTPSchemeType.HTTP,
 *                         Type = "HTTPGetAction",
 *                     },
 *                 },
 *                 ReadinessProbe = new AzureNative.AppPlatform.Inputs.ProbeArgs
 *                 {
 *                     DisableProbe = false,
 *                     FailureThreshold = 3,
 *                     InitialDelaySeconds = 30,
 *                     PeriodSeconds = 10,
 *                     ProbeAction = new AzureNative.AppPlatform.Inputs.HTTPGetActionArgs
 *                     {
 *                         Path = "/health",
 *                         Scheme = AzureNative.AppPlatform.HTTPSchemeType.HTTP,
 *                         Type = "HTTPGetAction",
 *                     },
 *                 },
 *                 ResourceRequests = new AzureNative.AppPlatform.Inputs.ResourceRequestsArgs
 *                 {
 *                     Cpu = "1000m",
 *                     Memory = "3Gi",
 *                 },
 *                 TerminationGracePeriodSeconds = 30,
 *             },
 *             Source = new AzureNative.AppPlatform.Inputs.CustomContainerUserSourceInfoArgs
 *             {
 *                 CustomContainer = new AzureNative.AppPlatform.Inputs.CustomContainerArgs
 *                 {
 *                     Args = new[]
 *                     {
 *                         "-c",
 *                         "while true; do echo hello; sleep 10;done",
 *                     },
 *                     Command = new[]
 *                     {
 *                         "/bin/sh",
 *                     },
 *                     ContainerImage = "myContainerImage:v1",
 *                     ImageRegistryCredential = new AzureNative.AppPlatform.Inputs.ImageRegistryCredentialArgs
 *                     {
 *                         Password = "myPassword",
 *                         Username = "myUsername",
 *                     },
 *                     LanguageFramework = "springboot",
 *                     Server = "myacr.azurecr.io",
 *                 },
 *                 Type = "Container",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewDeployment(ctx, "deployment", &appplatform.DeploymentArgs{
 * 			AppName:        pulumi.String("myapp"),
 * 			DeploymentName: pulumi.String("mydeployment"),
 * 			Properties: &appplatform.DeploymentResourcePropertiesArgs{
 * 				DeploymentSettings: &appplatform.DeploymentSettingsArgs{
 * 					EnvironmentVariables: pulumi.StringMap{
 * 						"env": pulumi.String("test"),
 * 					},
 * 					LivenessProbe: &appplatform.ProbeArgs{
 * 						DisableProbe:        pulumi.Bool(false),
 * 						FailureThreshold:    pulumi.Int(3),
 * 						InitialDelaySeconds: pulumi.Int(30),
 * 						PeriodSeconds:       pulumi.Int(10),
 * 						ProbeAction: appplatform.HTTPGetAction{
 * 							Path:   "/health",
 * 							Scheme: appplatform.HTTPSchemeTypeHTTP,
 * 							Type:   "HTTPGetAction",
 * 						},
 * 					},
 * 					ReadinessProbe: &appplatform.ProbeArgs{
 * 						DisableProbe:        pulumi.Bool(false),
 * 						FailureThreshold:    pulumi.Int(3),
 * 						InitialDelaySeconds: pulumi.Int(30),
 * 						PeriodSeconds:       pulumi.Int(10),
 * 						ProbeAction: appplatform.HTTPGetAction{
 * 							Path:   "/health",
 * 							Scheme: appplatform.HTTPSchemeTypeHTTP,
 * 							Type:   "HTTPGetAction",
 * 						},
 * 					},
 * 					ResourceRequests: &appplatform.ResourceRequestsArgs{
 * 						Cpu:    pulumi.String("1000m"),
 * 						Memory: pulumi.String("3Gi"),
 * 					},
 * 					TerminationGracePeriodSeconds: pulumi.Int(30),
 * 				},
 * 				Source: appplatform.CustomContainerUserSourceInfo{
 * 					CustomContainer: appplatform.CustomContainer{
 * 						Args: []string{
 * 							"-c",
 * 							"while true; do echo hello; sleep 10;done",
 * 						},
 * 						Command: []string{
 * 							"/bin/sh",
 * 						},
 * 						ContainerImage: "myContainerImage:v1",
 * 						ImageRegistryCredential: appplatform.ImageRegistryCredential{
 * 							Password: "myPassword",
 * 							Username: "myUsername",
 * 						},
 * 						LanguageFramework: "springboot",
 * 						Server:            "myacr.azurecr.io",
 * 					},
 * 					Type: "Container",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Deployment;
 * import com.pulumi.azurenative.appplatform.DeploymentArgs;
 * import com.pulumi.azurenative.appplatform.inputs.DeploymentResourcePropertiesArgs;
 * import com.pulumi.azurenative.appplatform.inputs.DeploymentSettingsArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ProbeArgs;
 * import com.pulumi.azurenative.appplatform.inputs.ResourceRequestsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .appName("myapp")
 *             .deploymentName("mydeployment")
 *             .properties(DeploymentResourcePropertiesArgs.builder()
 *                 .deploymentSettings(DeploymentSettingsArgs.builder()
 *                     .environmentVariables(Map.of("env", "test"))
 *                     .livenessProbe(ProbeArgs.builder()
 *                         .disableProbe(false)
 *                         .failureThreshold(3)
 *                         .initialDelaySeconds(30)
 *                         .periodSeconds(10)
 *                         .probeAction(HTTPGetActionArgs.builder()
 *                             .path("/health")
 *                             .scheme("HTTP")
 *                             .type("HTTPGetAction")
 *                             .build())
 *                         .build())
 *                     .readinessProbe(ProbeArgs.builder()
 *                         .disableProbe(false)
 *                         .failureThreshold(3)
 *                         .initialDelaySeconds(30)
 *                         .periodSeconds(10)
 *                         .probeAction(HTTPGetActionArgs.builder()
 *                             .path("/health")
 *                             .scheme("HTTP")
 *                             .type("HTTPGetAction")
 *                             .build())
 *                         .build())
 *                     .resourceRequests(ResourceRequestsArgs.builder()
 *                         .cpu("1000m")
 *                         .memory("3Gi")
 *                         .build())
 *                     .terminationGracePeriodSeconds(30)
 *                     .build())
 *                 .source(CustomContainerUserSourceInfoArgs.builder()
 *                     .customContainer(CustomContainerArgs.builder()
 *                         .args(
 *                             "-c",
 *                             "while true; do echo hello; sleep 10;done")
 *                         .command("/bin/sh")
 *                         .containerImage("myContainerImage:v1")
 *                         .imageRegistryCredential(ImageRegistryCredentialArgs.builder()
 *                             .password("myPassword")
 *                             .username("myUsername")
 *                             .build())
 *                         .languageFramework("springboot")
 *                         .server("myacr.azurecr.io")
 *                         .build())
 *                     .type("Container")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Deployment mydeployment /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/deployments/{deploymentName}
 * ```
 * @property appName The name of the App resource.
 * @property deploymentName The name of the Deployment resource.
 * @property properties Properties of the Deployment resource
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 * @property sku Sku of the Deployment resource
 */
public data class DeploymentArgs(
    public val appName: Output<String>? = null,
    public val deploymentName: Output<String>? = null,
    public val properties: Output<DeploymentResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.DeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.DeploymentArgs =
        com.pulumi.azurenative.appplatform.DeploymentArgs.builder()
            .appName(appName?.applyValue({ args0 -> args0 }))
            .deploymentName(deploymentName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeploymentArgs].
 */
@PulumiTagMarker
public class DeploymentArgsBuilder internal constructor() {
    private var appName: Output<String>? = null

    private var deploymentName: Output<String>? = null

    private var properties: Output<DeploymentResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    /**
     * @param value The name of the App resource.
     */
    @JvmName("mxctlthsupqenhdf")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value The name of the Deployment resource.
     */
    @JvmName("rklgvgojgfbrseyq")
    public suspend fun deploymentName(`value`: Output<String>) {
        this.deploymentName = value
    }

    /**
     * @param value Properties of the Deployment resource
     */
    @JvmName("lfqtndlftmnhbvhq")
    public suspend fun properties(`value`: Output<DeploymentResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("hpvbknkcnxjthuwe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("pjsgfppdputkyald")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Sku of the Deployment resource
     */
    @JvmName("ngkhxqbcdhgxbonm")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The name of the App resource.
     */
    @JvmName("adccopalyhhwisoi")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value The name of the Deployment resource.
     */
    @JvmName("vjdukunpysvoaitb")
    public suspend fun deploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentName = mapped
    }

    /**
     * @param value Properties of the Deployment resource
     */
    @JvmName("ycchticmelmbwpla")
    public suspend fun properties(`value`: DeploymentResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the Deployment resource
     */
    @JvmName("kvswgxbywirpdner")
    public suspend
    fun properties(argument: suspend DeploymentResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("btgocswtiicshixm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("cipcthesiyjedmpw")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Sku of the Deployment resource
     */
    @JvmName("fvejhpmahsvrjxpd")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku of the Deployment resource
     */
    @JvmName("utmsnwcbrvcomvhc")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    internal fun build(): DeploymentArgs = DeploymentArgs(
        appName = appName,
        deploymentName = deploymentName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        sku = sku,
    )
}
