@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayCustomDomainPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayCustomDomainPropertiesResponse.Companion.toKotlin as gatewayCustomDomainPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [GatewayCustomDomain].
 */
@PulumiTagMarker
public class GatewayCustomDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayCustomDomainArgs = GatewayCustomDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayCustomDomainArgsBuilder.() -> Unit) {
        val builder = GatewayCustomDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GatewayCustomDomain {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.GatewayCustomDomain(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GatewayCustomDomain(builtJavaResource)
    }
}

/**
 * Custom domain of the Spring Cloud Gateway
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### GatewayCustomDomains_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gatewayCustomDomain = new AzureNative.AppPlatform.GatewayCustomDomain("gatewayCustomDomain", new()
 *     {
 *         DomainName = "myDomainName",
 *         GatewayName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.GatewayCustomDomainPropertiesArgs
 *         {
 *             Thumbprint = "*",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewGatewayCustomDomain(ctx, "gatewayCustomDomain", &appplatform.GatewayCustomDomainArgs{
 * 			DomainName:  pulumi.String("myDomainName"),
 * 			GatewayName: pulumi.String("default"),
 * 			Properties: &appplatform.GatewayCustomDomainPropertiesArgs{
 * 				Thumbprint: pulumi.String("*"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.GatewayCustomDomain;
 * import com.pulumi.azurenative.appplatform.GatewayCustomDomainArgs;
 * import com.pulumi.azurenative.appplatform.inputs.GatewayCustomDomainPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gatewayCustomDomain = new GatewayCustomDomain("gatewayCustomDomain", GatewayCustomDomainArgs.builder()
 *             .domainName("myDomainName")
 *             .gatewayName("default")
 *             .properties(GatewayCustomDomainPropertiesArgs.builder()
 *                 .thumbprint("*")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:GatewayCustomDomain myDomainName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}/domains/{domainName}
 * ```
 */
public class GatewayCustomDomain internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.GatewayCustomDomain,
) : KotlinCustomResource(javaResource, GatewayCustomDomainMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of custom domain for Spring Cloud Gateway
     */
    public val properties: Output<GatewayCustomDomainPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                gatewayCustomDomainPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GatewayCustomDomainMapper : ResourceMapper<GatewayCustomDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.GatewayCustomDomain::class == javaResource::class

    override fun map(javaResource: Resource): GatewayCustomDomain = GatewayCustomDomain(
        javaResource
            as com.pulumi.azurenative.appplatform.GatewayCustomDomain,
    )
}

/**
 * @see [GatewayCustomDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayCustomDomain].
 */
public suspend fun gatewayCustomDomain(
    name: String,
    block: suspend GatewayCustomDomainResourceBuilder.() -> Unit,
): GatewayCustomDomain {
    val builder = GatewayCustomDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayCustomDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayCustomDomain(name: String): GatewayCustomDomain {
    val builder = GatewayCustomDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
