@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Scheme to use for connecting to the host. Defaults to HTTP.
 * Possible enum values:
 *  - `"HTTP"` means that the scheme used will be http://
 *  - `"HTTPS"` means that the scheme used will be https://
 */
public enum class HTTPSchemeType(
    public val javaValue: com.pulumi.azurenative.appplatform.enums.HTTPSchemeType,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.enums.HTTPSchemeType> {
    HTTP(com.pulumi.azurenative.appplatform.enums.HTTPSchemeType.HTTP),
    HTTPS(com.pulumi.azurenative.appplatform.enums.HTTPSchemeType.HTTPS),
    ;

    override fun toJava(): com.pulumi.azurenative.appplatform.enums.HTTPSchemeType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.enums.HTTPSchemeType):
            HTTPSchemeType = HTTPSchemeType.values().first { it.javaValue == javaType }
    }
}
