@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ApiPortalPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * API portal properties payload
 * @property gatewayIds The array of resource Ids of gateway to integrate with API portal.
 * @property httpsOnly Indicate if only https is allowed.
 * @property public Indicates whether the API portal exposes endpoint.
 * @property sourceUrls Collection of OpenAPI source URL locations.
 * @property ssoProperties Single sign-on related configuration
 */
public data class ApiPortalPropertiesArgs(
    public val gatewayIds: Output<List<String>>? = null,
    public val httpsOnly: Output<Boolean>? = null,
    public val `public`: Output<Boolean>? = null,
    public val sourceUrls: Output<List<String>>? = null,
    public val ssoProperties: Output<SsoPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ApiPortalPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ApiPortalPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.ApiPortalPropertiesArgs.builder()
            .gatewayIds(gatewayIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .httpsOnly(httpsOnly?.applyValue({ args0 -> args0 }))
            .public_(`public`?.applyValue({ args0 -> args0 }))
            .sourceUrls(sourceUrls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ssoProperties(ssoProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApiPortalPropertiesArgs].
 */
@PulumiTagMarker
public class ApiPortalPropertiesArgsBuilder internal constructor() {
    private var gatewayIds: Output<List<String>>? = null

    private var httpsOnly: Output<Boolean>? = null

    private var `public`: Output<Boolean>? = null

    private var sourceUrls: Output<List<String>>? = null

    private var ssoProperties: Output<SsoPropertiesArgs>? = null

    /**
     * @param value The array of resource Ids of gateway to integrate with API portal.
     */
    @JvmName("gsulqverwtygxhex")
    public suspend fun gatewayIds(`value`: Output<List<String>>) {
        this.gatewayIds = value
    }

    @JvmName("rrrugmpsoelusbkd")
    public suspend fun gatewayIds(vararg values: Output<String>) {
        this.gatewayIds = Output.all(values.asList())
    }

    /**
     * @param values The array of resource Ids of gateway to integrate with API portal.
     */
    @JvmName("ktdijuxdsrdkfukd")
    public suspend fun gatewayIds(values: List<Output<String>>) {
        this.gatewayIds = Output.all(values)
    }

    /**
     * @param value Indicate if only https is allowed.
     */
    @JvmName("fmtengsbhnlklcdj")
    public suspend fun httpsOnly(`value`: Output<Boolean>) {
        this.httpsOnly = value
    }

    /**
     * @param value Indicates whether the API portal exposes endpoint.
     */
    @JvmName("lmcobdxktlbrglyw")
    public suspend fun `public`(`value`: Output<Boolean>) {
        this.`public` = value
    }

    /**
     * @param value Collection of OpenAPI source URL locations.
     */
    @JvmName("xchkeewtrstsftsa")
    public suspend fun sourceUrls(`value`: Output<List<String>>) {
        this.sourceUrls = value
    }

    @JvmName("bclyecxfvcxpprcg")
    public suspend fun sourceUrls(vararg values: Output<String>) {
        this.sourceUrls = Output.all(values.asList())
    }

    /**
     * @param values Collection of OpenAPI source URL locations.
     */
    @JvmName("qmfmuxnxktefkcie")
    public suspend fun sourceUrls(values: List<Output<String>>) {
        this.sourceUrls = Output.all(values)
    }

    /**
     * @param value Single sign-on related configuration
     */
    @JvmName("aikcoviauowbmppb")
    public suspend fun ssoProperties(`value`: Output<SsoPropertiesArgs>) {
        this.ssoProperties = value
    }

    /**
     * @param value The array of resource Ids of gateway to integrate with API portal.
     */
    @JvmName("hnlvqkxhnjvpkban")
    public suspend fun gatewayIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayIds = mapped
    }

    /**
     * @param values The array of resource Ids of gateway to integrate with API portal.
     */
    @JvmName("tojuwolqixrhtpkq")
    public suspend fun gatewayIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gatewayIds = mapped
    }

    /**
     * @param value Indicate if only https is allowed.
     */
    @JvmName("tsqwhtqrmiippmhw")
    public suspend fun httpsOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsOnly = mapped
    }

    /**
     * @param value Indicates whether the API portal exposes endpoint.
     */
    @JvmName("guivckmxhvxlomvi")
    public suspend fun `public`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`public` = mapped
    }

    /**
     * @param value Collection of OpenAPI source URL locations.
     */
    @JvmName("yakfrmncxyopegly")
    public suspend fun sourceUrls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceUrls = mapped
    }

    /**
     * @param values Collection of OpenAPI source URL locations.
     */
    @JvmName("qxbkuvepjvgwjxsx")
    public suspend fun sourceUrls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceUrls = mapped
    }

    /**
     * @param value Single sign-on related configuration
     */
    @JvmName("jmbwauqglaciasrl")
    public suspend fun ssoProperties(`value`: SsoPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssoProperties = mapped
    }

    /**
     * @param argument Single sign-on related configuration
     */
    @JvmName("vuuennrwilbphdkq")
    public suspend fun ssoProperties(argument: suspend SsoPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SsoPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ssoProperties = mapped
    }

    internal fun build(): ApiPortalPropertiesArgs = ApiPortalPropertiesArgs(
        gatewayIds = gatewayIds,
        httpsOnly = httpsOnly,
        `public` = `public`,
        sourceUrls = sourceUrls,
        ssoProperties = ssoProperties,
    )
}
