@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.AzureFileVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of the Azure File volume. Azure File shares are mounted as volumes.
 * @property enableSubPath If set to true, it will create and mount a dedicated directory for every individual app instance.
 * @property mountOptions These are the mount options for a persistent disk.
 * @property mountPath The mount path of the persistent disk.
 * @property readOnly Indicates whether the persistent disk is a readOnly one.
 * @property shareName The share name of the Azure File share.
 * @property type The type of the underlying resource to mount as a persistent disk.
 * Expected value is 'AzureFileVolume'.
 */
public data class AzureFileVolumeArgs(
    public val enableSubPath: Output<Boolean>? = null,
    public val mountOptions: Output<List<String>>? = null,
    public val mountPath: Output<String>,
    public val readOnly: Output<Boolean>? = null,
    public val shareName: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.AzureFileVolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.AzureFileVolumeArgs =
        com.pulumi.azurenative.appplatform.inputs.AzureFileVolumeArgs.builder()
            .enableSubPath(enableSubPath?.applyValue({ args0 -> args0 }))
            .mountOptions(mountOptions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .mountPath(mountPath.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 }))
            .shareName(shareName?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFileVolumeArgs].
 */
@PulumiTagMarker
public class AzureFileVolumeArgsBuilder internal constructor() {
    private var enableSubPath: Output<Boolean>? = null

    private var mountOptions: Output<List<String>>? = null

    private var mountPath: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    private var shareName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value If set to true, it will create and mount a dedicated directory for every individual app instance.
     */
    @JvmName("dubwrvayubqqcclr")
    public suspend fun enableSubPath(`value`: Output<Boolean>) {
        this.enableSubPath = value
    }

    /**
     * @param value These are the mount options for a persistent disk.
     */
    @JvmName("gcvsnbevaknjlmpx")
    public suspend fun mountOptions(`value`: Output<List<String>>) {
        this.mountOptions = value
    }

    @JvmName("eyvauudjpmypmwql")
    public suspend fun mountOptions(vararg values: Output<String>) {
        this.mountOptions = Output.all(values.asList())
    }

    /**
     * @param values These are the mount options for a persistent disk.
     */
    @JvmName("ridebnqycmojcpql")
    public suspend fun mountOptions(values: List<Output<String>>) {
        this.mountOptions = Output.all(values)
    }

    /**
     * @param value The mount path of the persistent disk.
     */
    @JvmName("iuaqyrwmhafeimgw")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value Indicates whether the persistent disk is a readOnly one.
     */
    @JvmName("drcntqmscliavmto")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value The share name of the Azure File share.
     */
    @JvmName("evewtwvcqeyohqvo")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value The type of the underlying resource to mount as a persistent disk.
     * Expected value is 'AzureFileVolume'.
     */
    @JvmName("sgwuvewloahyjaje")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value If set to true, it will create and mount a dedicated directory for every individual app instance.
     */
    @JvmName("xbbyffldmjybvmpd")
    public suspend fun enableSubPath(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSubPath = mapped
    }

    /**
     * @param value These are the mount options for a persistent disk.
     */
    @JvmName("kcdypnnxfowgogfd")
    public suspend fun mountOptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param values These are the mount options for a persistent disk.
     */
    @JvmName("pipkxntuyvvygags")
    public suspend fun mountOptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param value The mount path of the persistent disk.
     */
    @JvmName("elvwipwqeimgqfpi")
    public suspend fun mountPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    /**
     * @param value Indicates whether the persistent disk is a readOnly one.
     */
    @JvmName("rwsxprpwucskolsb")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    /**
     * @param value The share name of the Azure File share.
     */
    @JvmName("pamlhtknfhpvideo")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value The type of the underlying resource to mount as a persistent disk.
     * Expected value is 'AzureFileVolume'.
     */
    @JvmName("svnshjtkfotaickq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureFileVolumeArgs = AzureFileVolumeArgs(
        enableSubPath = enableSubPath,
        mountOptions = mountOptions,
        mountPath = mountPath ?: throw PulumiNullFieldException("mountPath"),
        readOnly = readOnly,
        shareName = shareName,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
