@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.BuildServiceAgentPoolPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Build service agent pool properties
 * @property poolSize build service agent pool size properties
 */
public data class BuildServiceAgentPoolPropertiesArgs(
    public val poolSize: Output<BuildServiceAgentPoolSizePropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.BuildServiceAgentPoolPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.appplatform.inputs.BuildServiceAgentPoolPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.BuildServiceAgentPoolPropertiesArgs.builder()
            .poolSize(poolSize?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BuildServiceAgentPoolPropertiesArgs].
 */
@PulumiTagMarker
public class BuildServiceAgentPoolPropertiesArgsBuilder internal constructor() {
    private var poolSize: Output<BuildServiceAgentPoolSizePropertiesArgs>? = null

    /**
     * @param value build service agent pool size properties
     */
    @JvmName("wehppwdufmbsjred")
    public suspend fun poolSize(`value`: Output<BuildServiceAgentPoolSizePropertiesArgs>) {
        this.poolSize = value
    }

    /**
     * @param value build service agent pool size properties
     */
    @JvmName("ahpudfqxupbjjroa")
    public suspend fun poolSize(`value`: BuildServiceAgentPoolSizePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolSize = mapped
    }

    /**
     * @param argument build service agent pool size properties
     */
    @JvmName("oxhdsbbnryxrbhpu")
    public suspend
    fun poolSize(argument: suspend BuildServiceAgentPoolSizePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BuildServiceAgentPoolSizePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.poolSize = mapped
    }

    internal fun build(): BuildServiceAgentPoolPropertiesArgs = BuildServiceAgentPoolPropertiesArgs(
        poolSize = poolSize,
    )
}
