@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.BuildpackPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Buildpack properties payload
 * @property id Id of the buildpack
 */
public data class BuildpackPropertiesArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.BuildpackPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.BuildpackPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.BuildpackPropertiesArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BuildpackPropertiesArgs].
 */
@PulumiTagMarker
public class BuildpackPropertiesArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Id of the buildpack
     */
    @JvmName("vexgapefksddhalo")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Id of the buildpack
     */
    @JvmName("qaskkrmemfsjthre")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): BuildpackPropertiesArgs = BuildpackPropertiesArgs(
        id = id,
    )
}
