@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.BuildpacksGroupPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Buildpack group properties of the Builder
 * @property buildpacks Buildpacks in the buildpack group
 * @property name Buildpack group name
 */
public data class BuildpacksGroupPropertiesArgs(
    public val buildpacks: Output<List<BuildpackPropertiesArgs>>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.BuildpacksGroupPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.BuildpacksGroupPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.BuildpacksGroupPropertiesArgs.builder()
            .buildpacks(
                buildpacks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BuildpacksGroupPropertiesArgs].
 */
@PulumiTagMarker
public class BuildpacksGroupPropertiesArgsBuilder internal constructor() {
    private var buildpacks: Output<List<BuildpackPropertiesArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value Buildpacks in the buildpack group
     */
    @JvmName("wduopuyrtauftnxp")
    public suspend fun buildpacks(`value`: Output<List<BuildpackPropertiesArgs>>) {
        this.buildpacks = value
    }

    @JvmName("ycdgbexlodhwihkl")
    public suspend fun buildpacks(vararg values: Output<BuildpackPropertiesArgs>) {
        this.buildpacks = Output.all(values.asList())
    }

    /**
     * @param values Buildpacks in the buildpack group
     */
    @JvmName("jjxpnhtmyptldomi")
    public suspend fun buildpacks(values: List<Output<BuildpackPropertiesArgs>>) {
        this.buildpacks = Output.all(values)
    }

    /**
     * @param value Buildpack group name
     */
    @JvmName("gqkpfcnoutwgdwth")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Buildpacks in the buildpack group
     */
    @JvmName("hdgkdmfgpbxadnrg")
    public suspend fun buildpacks(`value`: List<BuildpackPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildpacks = mapped
    }

    /**
     * @param argument Buildpacks in the buildpack group
     */
    @JvmName("hyxwcyusdqicojou")
    public suspend fun buildpacks(argument: List<suspend BuildpackPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BuildpackPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buildpacks = mapped
    }

    /**
     * @param argument Buildpacks in the buildpack group
     */
    @JvmName("hsugrjopuqrkjvty")
    public suspend fun buildpacks(
        vararg
        argument: suspend BuildpackPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BuildpackPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buildpacks = mapped
    }

    /**
     * @param argument Buildpacks in the buildpack group
     */
    @JvmName("tkffhqxcjdkxcaqv")
    public suspend fun buildpacks(argument: suspend BuildpackPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BuildpackPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.buildpacks = mapped
    }

    /**
     * @param values Buildpacks in the buildpack group
     */
    @JvmName("mqxnvcavtmdlanrh")
    public suspend fun buildpacks(vararg values: BuildpackPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.buildpacks = mapped
    }

    /**
     * @param value Buildpack group name
     */
    @JvmName("txwivygsgveitodh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): BuildpacksGroupPropertiesArgs = BuildpacksGroupPropertiesArgs(
        buildpacks = buildpacks,
        name = name,
    )
}
