@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ContentCertificatePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of certificate imported from key vault.
 * @property content The content of uploaded certificate.
 * @property type The type of the certificate source.
 * Expected value is 'ContentCertificate'.
 */
public data class ContentCertificatePropertiesArgs(
    public val content: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ContentCertificatePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ContentCertificatePropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.ContentCertificatePropertiesArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentCertificatePropertiesArgs].
 */
@PulumiTagMarker
public class ContentCertificatePropertiesArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The content of uploaded certificate.
     */
    @JvmName("ypurqofefilrhylh")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The type of the certificate source.
     * Expected value is 'ContentCertificate'.
     */
    @JvmName("tdcuurneffrpcgeu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The content of uploaded certificate.
     */
    @JvmName("hyfcwsnpuppqaott")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The type of the certificate source.
     * Expected value is 'ContentCertificate'.
     */
    @JvmName("xxjgjmksxegpbgyn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ContentCertificatePropertiesArgs = ContentCertificatePropertiesArgs(
        content = content,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
