@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.DeploymentResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Deployment resource properties payload
 * @property active Indicates whether the Deployment is active
 * @property deploymentSettings Deployment settings of the Deployment
 * @property source Uploaded source information of the deployment.
 */
public data class DeploymentResourcePropertiesArgs(
    public val active: Output<Boolean>? = null,
    public val deploymentSettings: Output<DeploymentSettingsArgs>? = null,
    public val source: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.DeploymentResourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.DeploymentResourcePropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.DeploymentResourcePropertiesArgs.builder()
            .active(active?.applyValue({ args0 -> args0 }))
            .deploymentSettings(
                deploymentSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .source(source?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentResourcePropertiesArgs].
 */
@PulumiTagMarker
public class DeploymentResourcePropertiesArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var deploymentSettings: Output<DeploymentSettingsArgs>? = null

    private var source: Output<Any>? = null

    /**
     * @param value Indicates whether the Deployment is active
     */
    @JvmName("fmtavpudpgteqaif")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Deployment settings of the Deployment
     */
    @JvmName("bjqoqfhplxcgbutu")
    public suspend fun deploymentSettings(`value`: Output<DeploymentSettingsArgs>) {
        this.deploymentSettings = value
    }

    /**
     * @param value Uploaded source information of the deployment.
     */
    @JvmName("icfmmhlwlgmlxyxw")
    public suspend fun source(`value`: Output<Any>) {
        this.source = value
    }

    /**
     * @param value Indicates whether the Deployment is active
     */
    @JvmName("lpaanfvbftaalfii")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Deployment settings of the Deployment
     */
    @JvmName("wifvtmehmwkynnhg")
    public suspend fun deploymentSettings(`value`: DeploymentSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentSettings = mapped
    }

    /**
     * @param argument Deployment settings of the Deployment
     */
    @JvmName("bqwcyqdbejlbufve")
    public suspend
    fun deploymentSettings(argument: suspend DeploymentSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentSettings = mapped
    }

    /**
     * @param value Uploaded source information of the deployment.
     */
    @JvmName("qjnwfdlequhfwjgh")
    public suspend fun source(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): DeploymentResourcePropertiesArgs = DeploymentResourcePropertiesArgs(
        active = active,
        deploymentSettings = deploymentSettings,
        source = source,
    )
}
