@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.DevToolPortalPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Dev Tool Portal properties payload
 * @property features Settings for Dev Tool Portal
 * @property public Indicates whether the resource exposes public endpoint
 * @property ssoProperties Single sign-on related configuration
 */
public data class DevToolPortalPropertiesArgs(
    public val features: Output<DevToolPortalFeatureSettingsArgs>? = null,
    public val `public`: Output<Boolean>? = null,
    public val ssoProperties: Output<DevToolPortalSsoPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.DevToolPortalPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.DevToolPortalPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.DevToolPortalPropertiesArgs.builder()
            .features(features?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .public_(`public`?.applyValue({ args0 -> args0 }))
            .ssoProperties(ssoProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DevToolPortalPropertiesArgs].
 */
@PulumiTagMarker
public class DevToolPortalPropertiesArgsBuilder internal constructor() {
    private var features: Output<DevToolPortalFeatureSettingsArgs>? = null

    private var `public`: Output<Boolean>? = null

    private var ssoProperties: Output<DevToolPortalSsoPropertiesArgs>? = null

    /**
     * @param value Settings for Dev Tool Portal
     */
    @JvmName("enpcsaoqwryvpofi")
    public suspend fun features(`value`: Output<DevToolPortalFeatureSettingsArgs>) {
        this.features = value
    }

    /**
     * @param value Indicates whether the resource exposes public endpoint
     */
    @JvmName("dpsqsgoacowgxqoy")
    public suspend fun `public`(`value`: Output<Boolean>) {
        this.`public` = value
    }

    /**
     * @param value Single sign-on related configuration
     */
    @JvmName("lgwsylwbujxwwntk")
    public suspend fun ssoProperties(`value`: Output<DevToolPortalSsoPropertiesArgs>) {
        this.ssoProperties = value
    }

    /**
     * @param value Settings for Dev Tool Portal
     */
    @JvmName("tnrlrmwplnfunarn")
    public suspend fun features(`value`: DevToolPortalFeatureSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param argument Settings for Dev Tool Portal
     */
    @JvmName("hqeeiyjoeeopeqpl")
    public suspend
    fun features(argument: suspend DevToolPortalFeatureSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DevToolPortalFeatureSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.features = mapped
    }

    /**
     * @param value Indicates whether the resource exposes public endpoint
     */
    @JvmName("amtdqukfkvjudydw")
    public suspend fun `public`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`public` = mapped
    }

    /**
     * @param value Single sign-on related configuration
     */
    @JvmName("xrvphknmwycdbjxm")
    public suspend fun ssoProperties(`value`: DevToolPortalSsoPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssoProperties = mapped
    }

    /**
     * @param argument Single sign-on related configuration
     */
    @JvmName("yrmdsoosgtklwnge")
    public suspend
    fun ssoProperties(argument: suspend DevToolPortalSsoPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DevToolPortalSsoPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ssoProperties = mapped
    }

    internal fun build(): DevToolPortalPropertiesArgs = DevToolPortalPropertiesArgs(
        features = features,
        `public` = `public`,
        ssoProperties = ssoProperties,
    )
}
