@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GatewayApiMetadataPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * API metadata property for Spring Cloud Gateway
 * @property description Detailed description of the APIs available on the Gateway instance (default: `Generated OpenAPI 3 document that describes the API routes configured.`)
 * @property documentation Location of additional documentation for the APIs available on the Gateway instance
 * @property serverUrl Base URL that API consumers will use to access APIs on the Gateway instance.
 * @property title Title describing the context of the APIs available on the Gateway instance (default: `Spring Cloud Gateway for K8S`)
 * @property version Version of APIs available on this Gateway instance (default: `unspecified`).
 */
public data class GatewayApiMetadataPropertiesArgs(
    public val description: Output<String>? = null,
    public val documentation: Output<String>? = null,
    public val serverUrl: Output<String>? = null,
    public val title: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GatewayApiMetadataPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GatewayApiMetadataPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.GatewayApiMetadataPropertiesArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .documentation(documentation?.applyValue({ args0 -> args0 }))
            .serverUrl(serverUrl?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayApiMetadataPropertiesArgs].
 */
@PulumiTagMarker
public class GatewayApiMetadataPropertiesArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var documentation: Output<String>? = null

    private var serverUrl: Output<String>? = null

    private var title: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Detailed description of the APIs available on the Gateway instance (default: `Generated OpenAPI 3 document that describes the API routes configured.`)
     */
    @JvmName("ceopawefgtjhicls")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Location of additional documentation for the APIs available on the Gateway instance
     */
    @JvmName("jwvxiejhnwastwmm")
    public suspend fun documentation(`value`: Output<String>) {
        this.documentation = value
    }

    /**
     * @param value Base URL that API consumers will use to access APIs on the Gateway instance.
     */
    @JvmName("vnbhqyjfkllfccbb")
    public suspend fun serverUrl(`value`: Output<String>) {
        this.serverUrl = value
    }

    /**
     * @param value Title describing the context of the APIs available on the Gateway instance (default: `Spring Cloud Gateway for K8S`)
     */
    @JvmName("ydgbiabpqebioqyc")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Version of APIs available on this Gateway instance (default: `unspecified`).
     */
    @JvmName("psbhyykiabylaqaj")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Detailed description of the APIs available on the Gateway instance (default: `Generated OpenAPI 3 document that describes the API routes configured.`)
     */
    @JvmName("plgusylgxomqkljv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Location of additional documentation for the APIs available on the Gateway instance
     */
    @JvmName("tkgknsoliwvmobsh")
    public suspend fun documentation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentation = mapped
    }

    /**
     * @param value Base URL that API consumers will use to access APIs on the Gateway instance.
     */
    @JvmName("vcyleypchdoskotn")
    public suspend fun serverUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverUrl = mapped
    }

    /**
     * @param value Title describing the context of the APIs available on the Gateway instance (default: `Spring Cloud Gateway for K8S`)
     */
    @JvmName("yqrcpecjkclibsxn")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value Version of APIs available on this Gateway instance (default: `unspecified`).
     */
    @JvmName("nergiljriufxhaee")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): GatewayApiMetadataPropertiesArgs = GatewayApiMetadataPropertiesArgs(
        description = description,
        documentation = documentation,
        serverUrl = serverUrl,
        title = title,
        version = version,
    )
}
