@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GatewayApiRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * API route config of the Spring Cloud Gateway
 * @property description A description, will be applied to methods in the generated OpenAPI documentation.
 * @property filters To modify the request before sending it to the target endpoint, or the received response.
 * @property order Route processing order.
 * @property predicates A number of conditions to evaluate a route for each request. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
 * @property ssoEnabled Enable sso validation.
 * @property tags Classification tags, will be applied to methods in the generated OpenAPI documentation.
 * @property title A title, will be applied to methods in the generated OpenAPI documentation.
 * @property tokenRelay Pass currently-authenticated user's identity token to application service, default is 'false'
 * @property uri Full uri, will override `appName`.
 */
public data class GatewayApiRouteArgs(
    public val description: Output<String>? = null,
    public val filters: Output<List<String>>? = null,
    public val order: Output<Int>? = null,
    public val predicates: Output<List<String>>? = null,
    public val ssoEnabled: Output<Boolean>? = null,
    public val tags: Output<List<String>>? = null,
    public val title: Output<String>? = null,
    public val tokenRelay: Output<Boolean>? = null,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GatewayApiRouteArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GatewayApiRouteArgs =
        com.pulumi.azurenative.appplatform.inputs.GatewayApiRouteArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .filters(filters?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .order(order?.applyValue({ args0 -> args0 }))
            .predicates(predicates?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ssoEnabled(ssoEnabled?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .title(title?.applyValue({ args0 -> args0 }))
            .tokenRelay(tokenRelay?.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayApiRouteArgs].
 */
@PulumiTagMarker
public class GatewayApiRouteArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var filters: Output<List<String>>? = null

    private var order: Output<Int>? = null

    private var predicates: Output<List<String>>? = null

    private var ssoEnabled: Output<Boolean>? = null

    private var tags: Output<List<String>>? = null

    private var title: Output<String>? = null

    private var tokenRelay: Output<Boolean>? = null

    private var uri: Output<String>? = null

    /**
     * @param value A description, will be applied to methods in the generated OpenAPI documentation.
     */
    @JvmName("rinqfcgylksjcfeq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value To modify the request before sending it to the target endpoint, or the received response.
     */
    @JvmName("wkttdsofxbvlimoq")
    public suspend fun filters(`value`: Output<List<String>>) {
        this.filters = value
    }

    @JvmName("sahupmqtbllqqiqc")
    public suspend fun filters(vararg values: Output<String>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values To modify the request before sending it to the target endpoint, or the received response.
     */
    @JvmName("qimkgwyavxgqwwps")
    public suspend fun filters(values: List<Output<String>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value Route processing order.
     */
    @JvmName("ybtqfrnkvkfqxprc")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value A number of conditions to evaluate a route for each request. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
     */
    @JvmName("mcvwrthttpxywgce")
    public suspend fun predicates(`value`: Output<List<String>>) {
        this.predicates = value
    }

    @JvmName("nnwenhvgkhsdiflr")
    public suspend fun predicates(vararg values: Output<String>) {
        this.predicates = Output.all(values.asList())
    }

    /**
     * @param values A number of conditions to evaluate a route for each request. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
     */
    @JvmName("bihcihkkjxfmclcs")
    public suspend fun predicates(values: List<Output<String>>) {
        this.predicates = Output.all(values)
    }

    /**
     * @param value Enable sso validation.
     */
    @JvmName("ivwrrogtoukwbfyo")
    public suspend fun ssoEnabled(`value`: Output<Boolean>) {
        this.ssoEnabled = value
    }

    /**
     * @param value Classification tags, will be applied to methods in the generated OpenAPI documentation.
     */
    @JvmName("vemfucoiygfbcnys")
    public suspend fun tags(`value`: Output<List<String>>) {
        this.tags = value
    }

    @JvmName("pmgtwbgpvgenhckw")
    public suspend fun tags(vararg values: Output<String>) {
        this.tags = Output.all(values.asList())
    }

    /**
     * @param values Classification tags, will be applied to methods in the generated OpenAPI documentation.
     */
    @JvmName("ccrprqwljiwhnmnh")
    public suspend fun tags(values: List<Output<String>>) {
        this.tags = Output.all(values)
    }

    /**
     * @param value A title, will be applied to methods in the generated OpenAPI documentation.
     */
    @JvmName("vjkkcempbcyoiwpf")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Pass currently-authenticated user's identity token to application service, default is 'false'
     */
    @JvmName("xqcsjagdoknutekl")
    public suspend fun tokenRelay(`value`: Output<Boolean>) {
        this.tokenRelay = value
    }

    /**
     * @param value Full uri, will override `appName`.
     */
    @JvmName("edokhjcmkwimtard")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value A description, will be applied to methods in the generated OpenAPI documentation.
     */
    @JvmName("nddxpptbcmbabgtj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value To modify the request before sending it to the target endpoint, or the received response.
     */
    @JvmName("dvatfdcooxjvrkor")
    public suspend fun filters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param values To modify the request before sending it to the target endpoint, or the received response.
     */
    @JvmName("erossqwrlfpilxpm")
    public suspend fun filters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param value Route processing order.
     */
    @JvmName("csarfyhfvavlagdo")
    public suspend fun order(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value A number of conditions to evaluate a route for each request. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
     */
    @JvmName("hiawkvgtwskmbwfx")
    public suspend fun predicates(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predicates = mapped
    }

    /**
     * @param values A number of conditions to evaluate a route for each request. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
     */
    @JvmName("bbbdtfjifwxesvdk")
    public suspend fun predicates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.predicates = mapped
    }

    /**
     * @param value Enable sso validation.
     */
    @JvmName("ofqongglqfkjahid")
    public suspend fun ssoEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssoEnabled = mapped
    }

    /**
     * @param value Classification tags, will be applied to methods in the generated OpenAPI documentation.
     */
    @JvmName("bwntvylrwnhkksfe")
    public suspend fun tags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Classification tags, will be applied to methods in the generated OpenAPI documentation.
     */
    @JvmName("vffhboxgreuuifjh")
    public suspend fun tags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A title, will be applied to methods in the generated OpenAPI documentation.
     */
    @JvmName("uhvjkhflqasfjsdo")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value Pass currently-authenticated user's identity token to application service, default is 'false'
     */
    @JvmName("mcligqijkhnbfknv")
    public suspend fun tokenRelay(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenRelay = mapped
    }

    /**
     * @param value Full uri, will override `appName`.
     */
    @JvmName("dtootopnfvcuwfwk")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): GatewayApiRouteArgs = GatewayApiRouteArgs(
        description = description,
        filters = filters,
        order = order,
        predicates = predicates,
        ssoEnabled = ssoEnabled,
        tags = tags,
        title = title,
        tokenRelay = tokenRelay,
        uri = uri,
    )
}
