@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GatewayPropertiesEnvironmentVariablesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Environment variables of Spring Cloud Gateway
 * @property properties Non-sensitive properties
 * @property secrets Sensitive properties
 */
public data class GatewayPropertiesEnvironmentVariablesArgs(
    public val properties: Output<Map<String, String>>? = null,
    public val secrets: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GatewayPropertiesEnvironmentVariablesArgs> {
    override fun toJava():
        com.pulumi.azurenative.appplatform.inputs.GatewayPropertiesEnvironmentVariablesArgs =
        com.pulumi.azurenative.appplatform.inputs.GatewayPropertiesEnvironmentVariablesArgs.builder()
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .secrets(
                secrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GatewayPropertiesEnvironmentVariablesArgs].
 */
@PulumiTagMarker
public class GatewayPropertiesEnvironmentVariablesArgsBuilder internal constructor() {
    private var properties: Output<Map<String, String>>? = null

    private var secrets: Output<Map<String, String>>? = null

    /**
     * @param value Non-sensitive properties
     */
    @JvmName("mfbtylutqmbofxru")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Sensitive properties
     */
    @JvmName("iquwwmjwtjltkbyd")
    public suspend fun secrets(`value`: Output<Map<String, String>>) {
        this.secrets = value
    }

    /**
     * @param value Non-sensitive properties
     */
    @JvmName("wvvgchtiabghthfo")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Non-sensitive properties
     */
    @JvmName("wynugrurfnvoidol")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Sensitive properties
     */
    @JvmName("dbtluxixsltgilks")
    public suspend fun secrets(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param values Sensitive properties
     */
    @JvmName("cvognpxejnqwnkml")
    public fun secrets(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    internal fun build(): GatewayPropertiesEnvironmentVariablesArgs =
        GatewayPropertiesEnvironmentVariablesArgs(
            properties = properties,
            secrets = secrets,
        )
}
