@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetDeploymentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appName The name of the App resource.
 * @property deploymentName The name of the Deployment resource.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class GetDeploymentPlainArgs(
    public val appName: String,
    public val deploymentName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetDeploymentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetDeploymentPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetDeploymentPlainArgs.builder()
            .appName(appName.let({ args0 -> args0 }))
            .deploymentName(deploymentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeploymentPlainArgs].
 */
@PulumiTagMarker
public class GetDeploymentPlainArgsBuilder internal constructor() {
    private var appName: String? = null

    private var deploymentName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of the App resource.
     */
    @JvmName("fqlgsypyfdidvysd")
    public suspend fun appName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appName = mapped
    }

    /**
     * @param value The name of the Deployment resource.
     */
    @JvmName("drwerfkthbkyepdh")
    public suspend fun deploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("abpijdbexvdbbays")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("pmkssgxypnwrimym")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetDeploymentPlainArgs = GetDeploymentPlainArgs(
        appName = appName ?: throw PulumiNullFieldException("appName"),
        deploymentName = deploymentName ?: throw PulumiNullFieldException("deploymentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
