@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetStoragePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 * @property storageName The name of the storage resource.
 */
public data class GetStoragePlainArgs(
    public val resourceGroupName: String,
    public val serviceName: String,
    public val storageName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetStoragePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetStoragePlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetStoragePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .storageName(storageName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStoragePlainArgs].
 */
@PulumiTagMarker
public class GetStoragePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var storageName: String? = null

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("hwoabobqkyopkdvu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("lmubayobfuqxsgie")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the storage resource.
     */
    @JvmName("weofbuglefcccogb")
    public suspend fun storageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageName = mapped
    }

    internal fun build(): GetStoragePlainArgs = GetStoragePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        storageName = storageName ?: throw PulumiNullFieldException("storageName"),
    )
}
