@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.IngressConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Ingress configuration payload for Azure Spring Apps resource.
 * @property readTimeoutInSeconds Ingress read time out in seconds.
 */
public data class IngressConfigArgs(
    public val readTimeoutInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.IngressConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.IngressConfigArgs =
        com.pulumi.azurenative.appplatform.inputs.IngressConfigArgs.builder()
            .readTimeoutInSeconds(readTimeoutInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IngressConfigArgs].
 */
@PulumiTagMarker
public class IngressConfigArgsBuilder internal constructor() {
    private var readTimeoutInSeconds: Output<Int>? = null

    /**
     * @param value Ingress read time out in seconds.
     */
    @JvmName("mgrvexmsudoinppm")
    public suspend fun readTimeoutInSeconds(`value`: Output<Int>) {
        this.readTimeoutInSeconds = value
    }

    /**
     * @param value Ingress read time out in seconds.
     */
    @JvmName("pykbteilekprwrxm")
    public suspend fun readTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readTimeoutInSeconds = mapped
    }

    internal fun build(): IngressConfigArgs = IngressConfigArgs(
        readTimeoutInSeconds = readTimeoutInSeconds,
    )
}
