@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.JarUploadedUserSourceInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Uploaded Jar binary for a deployment
 * @property jvmOptions JVM parameter
 * @property relativePath Relative path of the storage which stores the source
 * @property runtimeVersion Runtime version of the Jar file
 * @property type Type of the source uploaded
 * Expected value is 'Jar'.
 * @property version Version of the source
 */
public data class JarUploadedUserSourceInfoArgs(
    public val jvmOptions: Output<String>? = null,
    public val relativePath: Output<String>? = null,
    public val runtimeVersion: Output<String>? = null,
    public val type: Output<String>,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.JarUploadedUserSourceInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.JarUploadedUserSourceInfoArgs =
        com.pulumi.azurenative.appplatform.inputs.JarUploadedUserSourceInfoArgs.builder()
            .jvmOptions(jvmOptions?.applyValue({ args0 -> args0 }))
            .relativePath(relativePath?.applyValue({ args0 -> args0 }))
            .runtimeVersion(runtimeVersion?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JarUploadedUserSourceInfoArgs].
 */
@PulumiTagMarker
public class JarUploadedUserSourceInfoArgsBuilder internal constructor() {
    private var jvmOptions: Output<String>? = null

    private var relativePath: Output<String>? = null

    private var runtimeVersion: Output<String>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value JVM parameter
     */
    @JvmName("kixuqcdourucpnmb")
    public suspend fun jvmOptions(`value`: Output<String>) {
        this.jvmOptions = value
    }

    /**
     * @param value Relative path of the storage which stores the source
     */
    @JvmName("uhwfuymhdqbdrray")
    public suspend fun relativePath(`value`: Output<String>) {
        this.relativePath = value
    }

    /**
     * @param value Runtime version of the Jar file
     */
    @JvmName("kfupgbxwsgilibbo")
    public suspend fun runtimeVersion(`value`: Output<String>) {
        this.runtimeVersion = value
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'Jar'.
     */
    @JvmName("tfbopjhypocgenio")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Version of the source
     */
    @JvmName("neajaarwiufgspwt")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value JVM parameter
     */
    @JvmName("mlfyslpwqtpfakul")
    public suspend fun jvmOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jvmOptions = mapped
    }

    /**
     * @param value Relative path of the storage which stores the source
     */
    @JvmName("ddokiyyaikkrglkr")
    public suspend fun relativePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativePath = mapped
    }

    /**
     * @param value Runtime version of the Jar file
     */
    @JvmName("csuvkohsguxwqkha")
    public suspend fun runtimeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeVersion = mapped
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'Jar'.
     */
    @JvmName("ebkjaelgbvaxfrpn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Version of the source
     */
    @JvmName("cvdgladqjyobnruj")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): JarUploadedUserSourceInfoArgs = JarUploadedUserSourceInfoArgs(
        jvmOptions = jvmOptions,
        relativePath = relativePath,
        runtimeVersion = runtimeVersion,
        type = type ?: throw PulumiNullFieldException("type"),
        version = version,
    )
}
