@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.KeyVaultCertificatePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of certificate imported from key vault.
 * @property certVersion The certificate version of key vault.
 * @property excludePrivateKey Optional. If set to true, it will not import private key from key vault.
 * @property keyVaultCertName The certificate name of key vault.
 * @property type The type of the certificate source.
 * Expected value is 'KeyVaultCertificate'.
 * @property vaultUri The vault uri of user key vault.
 */
public data class KeyVaultCertificatePropertiesArgs(
    public val certVersion: Output<String>? = null,
    public val excludePrivateKey: Output<Boolean>? = null,
    public val keyVaultCertName: Output<String>,
    public val type: Output<String>,
    public val vaultUri: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.KeyVaultCertificatePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.KeyVaultCertificatePropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.KeyVaultCertificatePropertiesArgs.builder()
            .certVersion(certVersion?.applyValue({ args0 -> args0 }))
            .excludePrivateKey(excludePrivateKey?.applyValue({ args0 -> args0 }))
            .keyVaultCertName(keyVaultCertName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .vaultUri(vaultUri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultCertificatePropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultCertificatePropertiesArgsBuilder internal constructor() {
    private var certVersion: Output<String>? = null

    private var excludePrivateKey: Output<Boolean>? = null

    private var keyVaultCertName: Output<String>? = null

    private var type: Output<String>? = null

    private var vaultUri: Output<String>? = null

    /**
     * @param value The certificate version of key vault.
     */
    @JvmName("xpfbgipkeiwxaitl")
    public suspend fun certVersion(`value`: Output<String>) {
        this.certVersion = value
    }

    /**
     * @param value Optional. If set to true, it will not import private key from key vault.
     */
    @JvmName("fayeckumeuieedhr")
    public suspend fun excludePrivateKey(`value`: Output<Boolean>) {
        this.excludePrivateKey = value
    }

    /**
     * @param value The certificate name of key vault.
     */
    @JvmName("kobbmadvrhpvrpjh")
    public suspend fun keyVaultCertName(`value`: Output<String>) {
        this.keyVaultCertName = value
    }

    /**
     * @param value The type of the certificate source.
     * Expected value is 'KeyVaultCertificate'.
     */
    @JvmName("qptbvynegqpbotkf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The vault uri of user key vault.
     */
    @JvmName("lvboqadevhrehfeq")
    public suspend fun vaultUri(`value`: Output<String>) {
        this.vaultUri = value
    }

    /**
     * @param value The certificate version of key vault.
     */
    @JvmName("fclwpnvemjsksixb")
    public suspend fun certVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certVersion = mapped
    }

    /**
     * @param value Optional. If set to true, it will not import private key from key vault.
     */
    @JvmName("rmmesjptalfjsors")
    public suspend fun excludePrivateKey(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludePrivateKey = mapped
    }

    /**
     * @param value The certificate name of key vault.
     */
    @JvmName("vabiosvpaxtwrobi")
    public suspend fun keyVaultCertName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultCertName = mapped
    }

    /**
     * @param value The type of the certificate source.
     * Expected value is 'KeyVaultCertificate'.
     */
    @JvmName("vnnlgkcktpnrpxtf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The vault uri of user key vault.
     */
    @JvmName("mmsdljqquymwramf")
    public suspend fun vaultUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultUri = mapped
    }

    internal fun build(): KeyVaultCertificatePropertiesArgs = KeyVaultCertificatePropertiesArgs(
        certVersion = certVersion,
        excludePrivateKey = excludePrivateKey,
        keyVaultCertName = keyVaultCertName ?: throw PulumiNullFieldException("keyVaultCertName"),
        type = type ?: throw PulumiNullFieldException("type"),
        vaultUri = vaultUri ?: throw PulumiNullFieldException("vaultUri"),
    )
}
