@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ServiceVNetAddonsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional Service settings in vnet injection instance
 * @property dataPlanePublicEndpoint Indicates whether the data plane components(log stream, app connect, remote debugging) in vnet injection instance could be accessed from internet.
 * @property logStreamPublicEndpoint Indicates whether the log stream in vnet injection instance could be accessed from internet.
 */
public data class ServiceVNetAddonsArgs(
    public val dataPlanePublicEndpoint: Output<Boolean>? = null,
    public val logStreamPublicEndpoint: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ServiceVNetAddonsArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ServiceVNetAddonsArgs =
        com.pulumi.azurenative.appplatform.inputs.ServiceVNetAddonsArgs.builder()
            .dataPlanePublicEndpoint(dataPlanePublicEndpoint?.applyValue({ args0 -> args0 }))
            .logStreamPublicEndpoint(logStreamPublicEndpoint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceVNetAddonsArgs].
 */
@PulumiTagMarker
public class ServiceVNetAddonsArgsBuilder internal constructor() {
    private var dataPlanePublicEndpoint: Output<Boolean>? = null

    private var logStreamPublicEndpoint: Output<Boolean>? = null

    /**
     * @param value Indicates whether the data plane components(log stream, app connect, remote debugging) in vnet injection instance could be accessed from internet.
     */
    @JvmName("nmalakdmevrfgjql")
    public suspend fun dataPlanePublicEndpoint(`value`: Output<Boolean>) {
        this.dataPlanePublicEndpoint = value
    }

    /**
     * @param value Indicates whether the log stream in vnet injection instance could be accessed from internet.
     */
    @JvmName("sepikvuaulkkfpfp")
    public suspend fun logStreamPublicEndpoint(`value`: Output<Boolean>) {
        this.logStreamPublicEndpoint = value
    }

    /**
     * @param value Indicates whether the data plane components(log stream, app connect, remote debugging) in vnet injection instance could be accessed from internet.
     */
    @JvmName("nevwalrdibaojrmu")
    public suspend fun dataPlanePublicEndpoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPlanePublicEndpoint = mapped
    }

    /**
     * @param value Indicates whether the log stream in vnet injection instance could be accessed from internet.
     */
    @JvmName("vdjwdjlqckixosoi")
    public suspend fun logStreamPublicEndpoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStreamPublicEndpoint = mapped
    }

    internal fun build(): ServiceVNetAddonsArgs = ServiceVNetAddonsArgs(
        dataPlanePublicEndpoint = dataPlanePublicEndpoint,
        logStreamPublicEndpoint = logStreamPublicEndpoint,
    )
}
